/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.security.SecurityContext;
import org.eclipse.osee.account.admin.OseePrincipal;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.server.internal.security.util.OseePrincipalImpl;

public class CustomSecurityContextImpl
implements SecurityContext,
Serializable {
    private static final long serialVersionUID = -8643469202637719566L;
    private OseePrincipal principal;

    public CustomSecurityContextImpl(OseePrincipal principal) {
        this.principal = principal;
    }

    public boolean isUserInRole(String role) {
        Collection<Object> roles = this.principal.getRoles();
        if (roles == null) {
            roles = java.util.Collections.emptyList();
        }
        return roles.contains(role);
    }

    public OseePrincipal getUserPrincipal() {
        return this.principal;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong((Long)this.principal.getGuid());
        this.writeString(out, this.principal.getDisplayName());
        this.writeString(out, this.principal.getEmailAddress());
        this.writeString(out, this.principal.getLogin());
        this.writeString(out, this.principal.getName());
        this.writeString(out, this.principal.getUserName());
        out.writeBoolean(this.principal.isActive());
        out.writeBoolean(this.principal.isAuthenticated());
        this.writeRoles(out, this.principal.getRoles());
        this.writeProps(out, this.principal.getProperties());
    }

    private void writeString(ObjectOutputStream out, String value) throws IOException {
        if (value != null) {
            out.writeObject(value);
        } else {
            out.writeObject("");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        Long uuid = in.readLong();
        String displayName = in.readUTF();
        String email = in.readUTF();
        String login = in.readUTF();
        String name = in.readUTF();
        String username = in.readUTF();
        boolean active = in.readBoolean();
        boolean authenticated = in.readBoolean();
        Set<String> roles = this.readRoles(in);
        Map<String, String> props = this.readProps(in);
        this.principal = new OseePrincipalImpl(uuid, displayName, email, login, name, username, active, authenticated, roles, props);
    }

    private void writeRoles(ObjectOutputStream out, Set<String> roles) throws IOException {
        this.writeString(out, Collections.toString((String)",", roles));
    }

    private Set<String> readRoles(ObjectInputStream in) throws IOException {
        Set<String> roles;
        String allRoles = in.readUTF();
        if (Strings.isValid((String)allRoles)) {
            roles = new LinkedHashSet();
            String[] stringArray = allRoles.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String role = stringArray[n2];
                roles.add(role);
                ++n2;
            }
        } else {
            roles = java.util.Collections.emptySet();
        }
        return roles;
    }

    private void writeProps(ObjectOutputStream out, Map<String, String> props) throws IOException {
        String value = props.toString();
        if (!value.equals("[]")) {
            value = value.substring(1, value.length() - 1);
            out.writeUTF(value);
        } else {
            out.writeUTF("");
        }
    }

    private Map<String, String> readProps(ObjectInputStream in) throws IOException {
        Map<String, String> props;
        String allProps = in.readUTF();
        if (Strings.isValid((String)allProps)) {
            props = new LinkedHashMap();
            String key = null;
            String[] stringArray = allProps.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (key == null) {
                    key = value;
                } else {
                    props.put(key, value);
                    key = null;
                }
                ++n2;
            }
        } else {
            props = java.util.Collections.emptyMap();
        }
        return props;
    }
}

