/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.ds;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Options
implements Cloneable {
    private static final String EXCEPTION_MESSAGE = "No setting found for key: [%s]";
    private final Map<String, Object> data = new HashMap<String, Object>();

    protected Options() {
    }

    public void reset() {
        this.data.clear();
    }

    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    public boolean isEmpty(String key) {
        String value = this.get(key);
        return value == null || "".equals(value);
    }

    public <T> T getObject(Class<T> clazz, String key) {
        return (T)this.getObject(key);
    }

    public Object getObject(String key) {
        return this.data.get(key);
    }

    public String get(String key) {
        Object value = this.getObject(key);
        return value != null ? String.valueOf(value) : null;
    }

    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.get(key));
    }

    public double getDouble(String key) throws NumberFormatException {
        String setting = this.get(key);
        if (setting == null) {
            throw new NumberFormatException(String.format(EXCEPTION_MESSAGE, key));
        }
        return Double.valueOf(setting);
    }

    public float getFloat(String key) throws NumberFormatException {
        String setting = this.get(key);
        if (setting == null) {
            throw new NumberFormatException(String.format(EXCEPTION_MESSAGE, key));
        }
        return Float.valueOf(setting).floatValue();
    }

    public int getInt(String key) throws NumberFormatException {
        String setting = this.get(key);
        if (setting == null) {
            throw new NumberFormatException(String.format(EXCEPTION_MESSAGE, key));
        }
        return Integer.valueOf(setting);
    }

    public long getLong(String key) throws NumberFormatException {
        String setting = this.get(key);
        if (setting == null) {
            throw new NumberFormatException(String.format(EXCEPTION_MESSAGE, key));
        }
        return Long.valueOf(setting);
    }

    public Date getDate(String key) throws IllegalArgumentException {
        String setting = this.get(key);
        if (setting == null) {
            throw new IllegalArgumentException(String.format(EXCEPTION_MESSAGE, key));
        }
        return new Date(Long.valueOf(setting));
    }

    public Date getDateOrNull(String key) throws IllegalArgumentException {
        String setting = this.get(key);
        Date toReturn = null;
        if (setting != null) {
            toReturn = this.getDate(key);
        }
        return toReturn;
    }

    public void put(String key, double value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, Object value) {
        this.data.put(key, value);
    }

    public void put(String key, float value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, int value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, long value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, String value) {
        this.data.put(key, value);
    }

    public void put(String key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, Date date) {
        if (date != null) {
            this.put(key, date.getTime());
        }
    }

    public void remove(String key) {
        this.data.remove(key);
    }

    public void setFrom(Options source) {
        this.data.clear();
        this.data.putAll(source.data);
    }

    public Options clone() {
        Options clone = new Options();
        clone.setFrom(this);
        return clone;
    }

    public String toString() {
        return "Options [data=" + this.data + "]";
    }
}

