/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.osee.framework.jdk.core.util.xml.XmlTransformAsProcess;

public final class XmlOutputTransform {
    private XmlOutputTransform() {
    }

    protected static void xmlToHtml(InputStream inputXML, InputStream inputXslt, Result result) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(inputXslt));
        XmlOutputTransform.xmlToHtml(inputXML, transformer, result);
    }

    private static void xmlToHtml(InputStream inputXML, Transformer transformer, Result result) throws Exception {
        try {
            transformer.transform(new StreamSource(inputXML), result);
        }
        catch (Exception ex) {
            throw new Exception("Error during Transform. ", ex);
        }
    }

    private static void xmlToHtml(InputStream inputXML, InputStream inputXslt, Writer result) throws Exception {
        boolean isNetworked = false;
        if (!isNetworked) {
            XmlOutputTransform.xmlToHtml(inputXML, inputXslt, (Result)new StreamResult(result));
        } else {
            XmlTransformAsProcess.getHtmlFromXml(inputXML, inputXslt, result);
        }
    }

    public static String xmlToHtmlString(String sourceFile, File transformToApply) {
        return XmlOutputTransform.xmlToHtmlString(new File(sourceFile), transformToApply);
    }

    public static String xmlToHtmlString(File sourceFile, String transformToApply) {
        return XmlOutputTransform.xmlToHtmlString(sourceFile, new File(transformToApply));
    }

    public static String xmlToHtmlString(String sourceFile, String transformToApply) {
        return XmlOutputTransform.xmlToHtmlString(new File(sourceFile), new File(transformToApply));
    }

    public static File xmlToHtmlFile(File sourceFile, File transformToApply) throws Exception {
        File file = new File(sourceFile.getAbsolutePath().replace(".tmo", ".html"));
        XmlOutputTransform.xmlToHtml((InputStream)new FileInputStream(sourceFile), (InputStream)new FileInputStream(transformToApply), new FileWriter(file));
        return file;
    }

    public static String xmlToHtmlString(File sourceFile, File transformToApply) {
        StringWriter sWriter = new StringWriter();
        try {
            XmlOutputTransform.xmlToHtml((InputStream)new FileInputStream(sourceFile), (InputStream)new FileInputStream(transformToApply), sWriter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sWriter.toString();
    }

    public static String xmlToHtmlString(InputStream sourceXML, Transformer transformer) throws Exception {
        StringWriter sWriter = new StringWriter();
        XmlOutputTransform.xmlToHtml(sourceXML, transformer, (Result)new StreamResult(sWriter));
        return sWriter.toString();
    }
}

