/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfaceElementArrayApi;
import org.eclipse.osee.mim.InterfaceElementEndpoint;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.PlatformTypeToken;

public class InterfaceElementEndpointImpl
implements InterfaceElementEndpoint {
    private final BranchId branch;
    private final UserId account;
    private final ArtifactId messageId;
    private final ArtifactId subMessageId;
    private final ArtifactId structureId;
    private final InterfaceElementApi elementApi;
    private final InterfaceElementArrayApi elementArrayApi;
    private final InterfacePlatformTypeApi platformApi;

    public InterfaceElementEndpointImpl(BranchId branch, UserId account, ArtifactId messageId, ArtifactId subMessageId, ArtifactId structureId, InterfaceElementApi interfaceElementApi, InterfaceElementArrayApi interfaceElementArrayApi, InterfacePlatformTypeApi interfacePlatformTypeApi) {
        this.account = account;
        this.branch = branch;
        this.messageId = messageId;
        this.subMessageId = subMessageId;
        this.structureId = structureId;
        this.elementApi = interfaceElementApi;
        this.elementArrayApi = interfaceElementArrayApi;
        this.platformApi = interfacePlatformTypeApi;
    }

    @Override
    public Collection<InterfaceStructureElementToken> getAllElements() {
        try {
            List elements = (List)this.elementApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceStructureContent_Structure, this.structureId, InterfaceStructureElementToken.class);
            for (InterfaceStructureElementToken element : elements) {
                PlatformTypeToken platformType = this.platformApi.getAccessor().getByRelationWithoutId(this.branch, CoreRelationTypes.InterfaceElementPlatformType_Element, ArtifactId.valueOf((Long)element.getId()), PlatformTypeToken.class);
                element.setPlatformTypeId(platformType.getId());
                element.setPlatformTypeName(platformType.getName());
            }
            return elements;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }

    @Override
    public InterfaceStructureElementToken getElement(ArtifactId elementId) {
        try {
            InterfaceStructureElementToken element = this.elementApi.getAccessor().getByRelation(this.branch, elementId, CoreRelationTypes.InterfaceStructureContent_Structure, this.structureId, InterfaceStructureElementToken.class);
            PlatformTypeToken platformType = this.platformApi.getAccessor().getByRelationWithoutId(this.branch, CoreRelationTypes.InterfaceElementPlatformType_Element, elementId, PlatformTypeToken.class);
            element.setPlatformTypeId(platformType.getId());
            element.setPlatformTypeName(platformType.getName());
            return element;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }
}

