/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.rest.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.account.rest.model.Link;

public class AccountWebPreferences {
    Map<String, Link> linksMap = new HashMap<String, Link>();

    public AccountWebPreferences() {
    }

    public AccountWebPreferences(Map<String, String> teamToPreferences) {
        for (String team : teamToPreferences.keySet()) {
            this.initPreferences(teamToPreferences.get(team), team);
        }
    }

    private void initPreferences(String string, String team) {
        try {
            ObjectMapper OM = new ObjectMapper();
            JsonNode jObject = OM.readTree(string);
            JsonNode jsonNode = jObject.get("links");
            if (jsonNode != null) {
                JsonNode linkJsonObject = OM.readTree(jsonNode.toString());
                Iterator keys = linkJsonObject.fieldNames();
                while (keys.hasNext()) {
                    String next = (String)keys.next();
                    JsonNode linkJObject = OM.readTree(linkJsonObject.get(next).toString());
                    Link link = new Link();
                    if (linkJObject.has("name")) {
                        link.setName(linkJObject.get("name").asText());
                    }
                    if (linkJObject.has("url")) {
                        link.setUrl(linkJObject.get("url").asText());
                    }
                    if (linkJObject.has("tags")) {
                        List array = linkJObject.findValuesAsText("tags");
                        int x = 0;
                        while (x < array.size()) {
                            link.getTags().add((String)array.get(x));
                            ++x;
                        }
                    }
                    link.setTeam(team);
                    link.setId(linkJObject.get("id").asText());
                    this.linksMap.put(next, link);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("exc: " + ex);
        }
    }

    public AccountWebPreferences(String jsonString, String team) {
        this.initPreferences(jsonString, team);
    }

    public Map<String, Link> getLinks() {
        return this.linksMap;
    }

    public void setLinks(Map<String, Link> links) {
        this.linksMap = links;
    }
}

