/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.email;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.IUserGroup;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.util.MailStatus;
import org.eclipse.osee.framework.jdk.core.util.EmailUtil;
import org.eclipse.osee.mail.api.MailMessage;
import org.eclipse.osee.mail.api.MailService;
import org.eclipse.osee.orcs.OrcsApi;

public class SupportEmailService {
    private MailService mailService;
    private OrcsApi orcsApi;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void setMailService(MailService mailService) {
        this.mailService = mailService;
    }

    public List<MailStatus> sendSupportEmail(String subject, String msg) {
        ArrayList<String> recipients = new ArrayList<String>();
        IUserGroup oseeSupportGroup = this.orcsApi.userService().getUserGroup(CoreUserGroups.OseeSupport);
        Collection members = oseeSupportGroup.getMembers();
        for (UserToken token : members) {
            String email = token.getEmail();
            if (!EmailUtil.isEmailValid((String)email)) continue;
            recipients.add(email);
        }
        List status = null;
        if (!recipients.isEmpty()) {
            MailMessage.MailMessageBuilder builder = MailMessage.newBuilder();
            builder.addText(msg);
            builder.subject(subject);
            builder.replyTo(new String[]{this.mailService.getReplyToEmail()});
            builder.from(this.mailService.getAdminEmail());
            builder.recipients(recipients);
            MailMessage message = builder.build();
            status = this.mailService.sendMessages(new MailMessage[]{message});
        }
        return status;
    }
}

