/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osee.disposition.model.LocationRange;

public class LocationRangesCompressor {
    public static String compress(List<Integer> locationPoints) {
        Collections.sort(locationPoints);
        StringBuilder workingLocRefs = new StringBuilder();
        boolean isRange = false;
        boolean endOfRange = false;
        int startOfRange = -1;
        int previous = -1;
        Iterator<Integer> iterator = locationPoints.iterator();
        while (iterator.hasNext()) {
            boolean isLastElement;
            int currentTestPoint = iterator.next();
            boolean bl = isLastElement = !iterator.hasNext();
            if (currentTestPoint != 0 && previous == currentTestPoint - 1 && startOfRange == -1) {
                isRange = true;
                endOfRange = false;
                startOfRange = previous;
                int lastIndexOf = workingLocRefs.lastIndexOf(",");
                if (lastIndexOf > 0) {
                    workingLocRefs.replace(lastIndexOf, workingLocRefs.length(), "");
                } else {
                    workingLocRefs.setLength(0);
                }
            }
            if (isRange && (previous != currentTestPoint - 1 || isLastElement)) {
                endOfRange = true;
            }
            StringBuilder toAppend = new StringBuilder();
            if (!isRange) {
                toAppend.append(currentTestPoint);
            } else if (endOfRange) {
                if (previous != currentTestPoint - 1) {
                    toAppend.append(new LocationRange(startOfRange, previous).toString());
                    toAppend.append(", ");
                    toAppend.append(currentTestPoint);
                } else {
                    toAppend.append(new LocationRange(startOfRange, currentTestPoint).toString());
                }
                isRange = false;
                startOfRange = -1;
            }
            if (toAppend.length() != 0) {
                if (workingLocRefs.length() > 0) {
                    workingLocRefs.append(", ");
                }
                workingLocRefs.append((CharSequence)toAppend);
            }
            previous = currentTestPoint;
        }
        return workingLocRefs.toString();
    }
}

