/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util.health.check;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.health.HealthCheckResults;
import org.eclipse.osee.ats.api.util.health.IAtsHealthCheck;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.rest.internal.util.health.check.AtsHealthQueries;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;

public class TestWorkflowVersions
implements IAtsHealthCheck {
    private final HashCollectionSet<IAtsTeamDefinition, IAtsVersion> teamDefToVersions = new HashCollectionSet(HashSet::new);

    public void check(ArtifactToken artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi, IAtsChangeSet changes) {
        if (workItem.isTeamWorkflow()) {
            IAtsVersion version;
            IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)workItem;
            Collection versions = atsApi.getRelationResolver().getRelated((IAtsObject)teamWf, AtsRelationTypes.TeamWorkflowTargetedForVersion_Version);
            if (versions.size() == 1 && (version = (IAtsVersion)atsApi.getQueryService().getConfigItem((ArtifactId)versions.iterator().next())) != null && !this.getTeamVersions(teamWf.getTeamDefinition(), atsApi).contains(version)) {
                this.error(results, workItem, "Team workflow " + teamWf.getAtsId() + " has version" + version.toStringWithId() + " that does not belong to teamDefHoldingVersions ", new Object[0]);
            }
        }
    }

    private Collection<IAtsVersion> getTeamVersions(IAtsTeamDefinition teamDef, AtsApi atsApi) {
        IAtsTeamDefinition teamDefHoldingVers;
        HashSet teamDefVersions = (HashSet)this.teamDefToVersions.getValues((Object)teamDef);
        if (teamDefVersions == null && (teamDefHoldingVers = atsApi.getTeamDefinitionService().getTeamDefHoldingVersions(teamDef)) != null) {
            teamDefVersions = new HashSet();
            teamDefVersions.addAll(atsApi.getTeamDefinitionService().getVersions(teamDefHoldingVers));
            this.teamDefToVersions.put((Object)teamDef, teamDefVersions);
        }
        return teamDefVersions;
    }

    public void check(HealthCheckResults results, AtsApi atsApi) {
        for (IAtsWorkItem workItem : atsApi.getQueryService().getWorkItemsFromQuery(AtsHealthQueries.getArtIdsOfMuiltipleRelsOnSide(atsApi, atsApi.getAtsBranch(), AtsRelationTypes.TeamWorkflowTargetedForVersion_TeamWorkflow), new Object[0])) {
            this.error(results, workItem, "Team Workflow with mulitple versions found", new Object[]{workItem.toStringWithId()});
        }
    }
}

