/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.sql.join;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.eclipse.osee.framework.core.enums.JoinItem;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.OseePreparedStatement;
import org.eclipse.osee.orcs.OseeDb;

public abstract class AbstractJoinQuery
implements AutoCloseable {
    private static final Long DEFAULT_JOIN_EXPIRATION_SECONDS = 10800L;
    private static final String SELECT_QUERY_IDS = "select DISTINCT query_id from %s";
    private static final String DELETE_FROM_JOIN_CLEANUP = "DELETE FROM osee_join_cleanup WHERE query_id =?";
    private static final Random random = new Random();
    private final JoinItem joinItem;
    private final int queryId;
    private final JdbcClient jdbcClient;
    private final JdbcConnection connection;
    private final OseePreparedStatement addressing;
    private boolean wasStored;

    protected AbstractJoinQuery(JoinItem joinItem, JdbcClient jdbcClient, JdbcConnection connection) {
        this.joinItem = joinItem;
        this.queryId = random.nextInt();
        this.jdbcClient = jdbcClient;
        this.connection = connection;
        this.addressing = jdbcClient.getBatchStatement(connection, joinItem.getInsertSql());
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.addressing.size();
    }

    public int getQueryId() {
        return this.queryId;
    }

    public boolean wasStored() {
        return this.wasStored;
    }

    public void store() {
        if (this.wasStored) {
            throw new OseeCoreException("Cannot store query id twice", new Object[0]);
        }
        this.jdbcClient.runPreparedUpdate(this.connection, OseeDb.OSEE_JOIN_CLEANUP_TABLE.getInsertSql(), new Object[]{this.queryId, this.joinItem.getJoinTableName(), this.getIssuedAt(), DEFAULT_JOIN_EXPIRATION_SECONDS});
        this.addressing.execute();
        this.wasStored = true;
    }

    private Long getIssuedAt() {
        return System.currentTimeMillis() / 1000L;
    }

    @Override
    public void close() {
        if (this.wasStored) {
            this.jdbcClient.runPreparedUpdate(this.connection, this.joinItem.getDeleteSql(), new Object[]{this.queryId});
            this.jdbcClient.runPreparedUpdate(this.connection, DELETE_FROM_JOIN_CLEANUP, new Object[]{this.queryId});
        } else {
            this.addressing.close();
        }
    }

    public Collection<Integer> getAllQueryIds() {
        ArrayList<Integer> queryIds = new ArrayList<Integer>();
        String query = String.format(SELECT_QUERY_IDS, this.joinItem.getJoinTableName());
        this.jdbcClient.runQuery(this.connection, stmt -> {
            boolean bl = queryIds.add(stmt.getInt("query_id"));
        }, query, new Object[0]);
        return queryIds;
    }

    public String toString() {
        return String.format("id: [%s] entrySize: [%d]", this.getQueryId(), this.size());
    }

    protected void addToBatch(Object obj1) {
        this.addressing.addToBatch((Object)this.queryId, obj1);
    }

    protected void addToBatch(Object obj1, Object obj2) {
        this.addressing.addToBatch((Object)this.queryId, obj1, obj2);
    }

    protected void addToBatch(Object obj1, Object obj2, Object obj3, Object obj4) {
        this.addressing.addToBatch((Object)this.queryId, obj1, obj2, obj3, obj4);
    }

    public void addAll(Iterable<?> values) {
        for (Object value : values) {
            this.addressing.addToBatch((Object)this.queryId, value);
        }
    }

    public void addAndStore(Iterable<?> values) {
        this.addAll(values);
        this.store();
    }
}

