/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.data;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.BranchType;

public class CreateBranchData {
    private final BranchId MERGE_DESTINATION_BRANCH_ID = BranchId.SENTINEL;
    private final int MERGE_ADDRESSING_QUERY_ID = -1;
    private String branchName;
    private final BranchId branch;
    private BranchType branchType;
    private String creationComment;
    private TransactionToken fromTransaction;
    private TransactionId savedTransaction;
    private ArtifactId associatedArtifact;
    private ArtifactId author;
    private int mergeAddressingQueryId = -1;
    private BranchId mergeDestinationBranchId = this.MERGE_DESTINATION_BRANCH_ID;
    private boolean txCopyBranchType = false;
    private BranchId parentBranch;

    public CreateBranchData() {
        this(BranchId.create());
    }

    public CreateBranchData(BranchId branch) {
        this.branch = branch;
    }

    public CreateBranchData(IOseeBranch branch) {
        this.branch = branch;
        this.branchName = branch.getName();
    }

    public ArtifactId getAssociatedArtifact() {
        return this.associatedArtifact;
    }

    public String getName() {
        return this.branchName;
    }

    public void setName(String branchName) {
        this.branchName = branchName;
    }

    public BranchType getBranchType() {
        return this.branchType;
    }

    public void setBranchType(BranchType branchType) {
        this.branchType = branchType;
    }

    public String getCreationComment() {
        return this.creationComment;
    }

    public void setCreationComment(String creationComment) {
        this.creationComment = creationComment;
    }

    public TransactionToken getFromTransaction() {
        return this.fromTransaction;
    }

    public void setFromTransaction(TransactionToken fromTransaction) {
        this.fromTransaction = fromTransaction;
    }

    public TransactionId getSavedTransaction() {
        return this.savedTransaction;
    }

    public void setSavedTransaction(TransactionId priorTransaction) {
        this.savedTransaction = priorTransaction;
    }

    public ArtifactId getAuthor() {
        return this.author;
    }

    public void setAuthor(ArtifactId author) {
        this.author = author;
    }

    public void setAssociatedArtifact(ArtifactId associatedArtifact) {
        this.associatedArtifact = associatedArtifact;
    }

    public int getMergeAddressingQueryId() {
        return this.mergeAddressingQueryId;
    }

    public void setMergeAddressingQueryId(int mergeAddressingQueryId) {
        this.mergeAddressingQueryId = mergeAddressingQueryId;
    }

    public BranchId getMergeDestinationBranchId() {
        return this.mergeDestinationBranchId;
    }

    public void setMergeDestinationBranchId(BranchId destinationBranchId) {
        this.mergeDestinationBranchId = destinationBranchId;
    }

    public int hashCode() {
        return this.branch.hashCode();
    }

    public boolean equals(Object obj) {
        return this.branch.equals(obj);
    }

    public boolean isTxCopyBranchType() {
        return this.txCopyBranchType;
    }

    public void setTxCopyBranchType(boolean value) {
        this.txCopyBranchType = value;
    }

    public String toString() {
        return "CreateBranchData [branchUuid=" + this.branch + ", branchName=" + this.branchName + ", branchType=" + this.branchType + ", creationComment=" + this.creationComment + ", fromTransaction=" + this.fromTransaction + ", associatedArtifact=" + this.associatedArtifact + ", author=" + this.author + ", mergeAddressingQueryId=" + this.mergeAddressingQueryId + ", destinationBranchId=" + this.mergeDestinationBranchId + "]";
    }

    public BranchId getBranch() {
        return this.branch;
    }

    public void setParentBranch(BranchId parentBranch) {
        this.parentBranch = parentBranch;
    }

    public BranchId getParentBranch() {
        return this.parentBranch;
    }
}

