/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.orcs.data.ArtifactReadableImpl;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.data.HasTransaction;
import org.eclipse.osee.orcs.data.OrcsReadable;
import org.eclipse.osee.orcs.data.RelationReadable;

public interface ArtifactReadable
extends ArtifactToken,
HasTransaction,
OrcsReadable {
    public static final ArtifactReadableImpl SENTINEL = new ArtifactReadableImpl(Id.SENTINEL, CoreArtifactTypes.Artifact, (BranchId)CoreBranches.COMMON, ArtifactId.SENTINEL, ApplicabilityId.BASE, TransactionId.SENTINEL, ModificationType.SENTINEL, null, null);

    public TransactionId getLastModifiedTransaction();

    public boolean isOfType(ArtifactTypeId ... var1);

    public int getAttributeCount(AttributeTypeToken var1);

    public int getAttributeCount(AttributeTypeToken var1, DeletionFlag var2);

    public boolean isAttributeTypeValid(AttributeTypeToken var1);

    public Collection<AttributeTypeToken> getValidAttributeTypes();

    public Collection<AttributeTypeToken> getExistingAttributeTypes();

    public <T> T getSoleAttributeValue(AttributeTypeToken var1);

    public <T> T getSoleAttributeValue(AttributeTypeToken var1, DeletionFlag var2, T var3);

    public <T> T getSoleAttributeValue(AttributeTypeToken var1, T var2);

    public String getSoleAttributeAsString(AttributeTypeToken var1);

    public String getSoleAttributeAsString(AttributeTypeToken var1, String var2);

    public Long getSoleAttributeId(AttributeTypeToken var1);

    public <T> List<T> getAttributeValues(AttributeTypeToken var1);

    public Iterable<Collection<? extends AttributeReadable<Object>>> getAttributeIterable();

    public AttributeReadable<Object> getAttributeById(AttributeId var1);

    public ResultSet<? extends AttributeReadable<Object>> getAttributes();

    public <T> ResultSet<? extends AttributeReadable<T>> getAttributes(AttributeTypeId var1);

    public ResultSet<? extends AttributeReadable<Object>> getAttributes(DeletionFlag var1);

    public <T> ResultSet<? extends AttributeReadable<T>> getAttributes(AttributeTypeToken var1, DeletionFlag var2);

    default public String getAttributeValuesAsString(AttributeTypeToken attributeType) {
        return Collections.toString((String)", ", this.getAttributeValues(attributeType));
    }

    public int getMaximumRelationAllowed(RelationTypeSide var1);

    public Collection<RelationTypeId> getValidRelationTypes();

    public Collection<RelationTypeId> getExistingRelationTypes();

    default public ArtifactReadable getParent() {
        return (ArtifactReadable)Collections.exactlyOne(this.getRelated(CoreRelationTypes.Default_Hierarchical__Parent, ArtifactTypeId.SENTINEL));
    }

    public List<ArtifactReadable> getDescendants();

    public void getDescendants(List<ArtifactReadable> var1);

    public boolean isDescendantOf(ArtifactToken var1);

    default public List<ArtifactReadable> getAncestors() {
        ArrayList<ArtifactReadable> ancestors = new ArrayList<ArtifactReadable>();
        ArtifactReadable parent = this.getParent();
        while (parent != null) {
            ancestors.add(parent);
            parent = parent.getParent();
        }
        return ancestors;
    }

    public List<ArtifactReadable> getChildren();

    default public ArtifactReadable getChild() {
        return (ArtifactReadable)Collections.exactlyOne(this.getChildren());
    }

    public ResultSet<ArtifactReadable> getRelated(RelationTypeSide var1);

    default public List<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide, ArtifactTypeId artifactType) {
        ArrayList<ArtifactReadable> artifacts = new ArrayList<ArtifactReadable>();
        for (ArtifactReadable artifact : this.getRelated(relationTypeSide)) {
            if (!artifact.isOfType(artifactType)) continue;
            artifacts.add(artifact);
        }
        return artifacts;
    }

    default public List<ArtifactToken> getRelatedIds(RelationTypeSide relationTypeSide, ArtifactTypeId artifactType) {
        return Collections.cast(this.getRelated(relationTypeSide, artifactType));
    }

    public List<ArtifactReadable> getRelated(RelationTypeSide var1, DeletionFlag var2);

    public List<ArtifactReadable> getRelated(RelationTypeSide var1, ArtifactTypeId var2, DeletionFlag var3);

    public boolean areRelated(RelationTypeSide var1, ArtifactReadable var2);

    public int getRelatedCount(RelationTypeSide var1);

    public String getRationale(RelationTypeSide var1, ArtifactReadable var2);

    public ResultSet<RelationReadable> getRelations(RelationTypeSide var1);

    public Collection<Long> getChildrentIds();

    public Collection<Long> getRelatedIds(RelationTypeSide var1);

    public boolean isHistorical();

    public ApplicabilityId getApplicability();

    public String getSafeName();
}

