/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.text.tool.FindResultsIterator;

public class FindResults {
    private final HashMap<String, HashMap<File, List<String>>> results;

    public FindResults(int initialCapacity) {
        this.results = new HashMap(initialCapacity * 4 / 3);
    }

    public void addMatch(String pattern, File file, String region) {
        List<String> regions;
        HashMap<File, List<String>> fileMatches = this.results.get(pattern);
        if (fileMatches == null) {
            fileMatches = new HashMap();
            this.results.put(pattern, fileMatches);
        }
        if ((regions = fileMatches.get(file)) == null) {
            regions = new LinkedList<String>();
            fileMatches.put(file, regions);
        }
        regions.add(region);
    }

    public void writeFindResutls(Writer out) throws IOException {
        FindResultsIterator i = this.iterator();
        while (i.hasNext()) {
            out.write(i.currentPattern);
            out.write(64);
            out.write(i.currentFile.getName());
            out.write(64);
            if (i.currentRegion != null) {
                out.write(i.currentRegion);
            }
            out.write("\n");
        }
    }

    public FindResultsIterator iterator() {
        return new FindResultsIterator(this.results);
    }

    public Set<File> getFileSet() {
        LinkedHashSet<File> files = new LinkedHashSet<File>(1000);
        for (Map.Entry<String, HashMap<File, List<String>>> entry : this.results.entrySet()) {
            HashMap<File, List<String>> fileMatches = entry.getValue();
            files.addAll(fileMatches.keySet());
        }
        return files;
    }

    public HashMap<String, List<File>> getRegionToFileMapping() {
        HashMap<String, List<File>> mapping = new HashMap<String, List<File>>(1000);
        FindResultsIterator i = this.iterator();
        while (i.hasNext()) {
            List<File> files = mapping.get(i.currentRegion);
            if (files == null) {
                files = new LinkedList<File>();
                mapping.put(i.currentRegion, files);
            }
            files.add(i.currentFile);
        }
        return mapping;
    }

    public IteratorPerPattern getIteratorForPattern(String pattern) {
        return new IteratorPerPattern(pattern);
    }

    public class IteratorPerPattern {
        private final String pattern;
        private Iterator<Map.Entry<File, List<String>>> fileIterator;
        private Iterator<String> listIterator;
        private boolean more;
        public File currentFile;
        public String currentRegion;

        private IteratorPerPattern(String pattern) {
            this.pattern = pattern;
            this.reset();
        }

        public void reset() {
            HashMap fileMatches = (HashMap)FindResults.this.results.get(this.pattern);
            this.fileIterator = fileMatches.entrySet().iterator();
            this.listIterator = null;
            this.more = true;
        }

        private void primePump() {
            if (this.listIterator == null || !this.listIterator.hasNext()) {
                if (!this.fileIterator.hasNext()) {
                    this.more = false;
                    return;
                }
                Map.Entry<File, List<String>> entry = this.fileIterator.next();
                this.currentFile = entry.getKey();
                List<String> list = entry.getValue();
                this.listIterator = list.iterator();
            }
            this.currentRegion = this.listIterator.next();
        }

        public boolean hasNext() {
            this.primePump();
            return this.more;
        }
    }
}

