/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.types;

import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.core.ds.OrcsTypesDataStore;
import org.eclipse.osee.orcs.core.internal.types.BranchHierarchyProvider;
import org.eclipse.osee.orcs.core.internal.types.OrcsTypesIndexProvider;
import org.eclipse.osee.orcs.core.internal.types.OrcsTypesLoader;
import org.eclipse.osee.orcs.core.internal.types.OrcsTypesLoaderFactory;
import org.eclipse.osee.orcs.core.internal.types.impl.OrcsTypesImpl;
import org.eclipse.osee.orcs.core.internal.types.impl.OrcsTypesIndexProviderImpl;
import org.eclipse.osee.orcs.core.internal.types.impl.OrcsTypesLoaderFactoryImpl;

public class OrcsTypesModule {
    private final Log logger;
    private final OrcsTypesDataStore dataStore;
    private final BranchHierarchyProvider hierarchy;
    private OrcsTypesLoaderFactory factory;
    private OrcsTypesIndexProvider indexer;

    public OrcsTypesModule(Log logger, OrcsTypesDataStore dataStore, BranchHierarchyProvider hierarchy) {
        this.logger = logger;
        this.dataStore = dataStore;
        this.hierarchy = hierarchy;
    }

    public void start(OrcsSession session) {
        this.factory = this.createFactory();
        this.indexer = this.createIndexer(this.factory.createTypesLoader(session, this.dataStore));
    }

    public void stop() {
        this.factory = null;
        this.indexer = null;
    }

    protected OrcsTypesLoaderFactory createFactory() {
        return new OrcsTypesLoaderFactoryImpl(this.logger, this.hierarchy);
    }

    protected OrcsTypesIndexProvider createIndexer(OrcsTypesLoader loader) {
        return new OrcsTypesIndexProviderImpl(loader);
    }

    public OrcsTypes createOrcsTypes(OrcsSession session) {
        return new OrcsTypesImpl(this.logger, session, this.dataStore, this.factory, this.indexer);
    }
}

