/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute.primitives;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.core.annotations.OseeAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.BinaryAttribute;

@OseeAttribute(value="JavaObjectAttribute")
public final class JavaObjectAttribute
extends BinaryAttribute<Object> {
    public static final String NAME = JavaObjectAttribute.class.getSimpleName();

    public JavaObjectAttribute(Long id) {
        super(id);
    }

    @Override
    public Object getValue() {
        return this.getObjectFromBytes(this.getDataProxy().getValueAsBytes());
    }

    private Object getObjectFromBytes(ByteBuffer buffer) {
        Object obj;
        block23: {
            obj = null;
            InputStream inputStream = null;
            ObjectInputStream objectStream = null;
            try {
                try {
                    inputStream = Lib.byteBufferToInputStream((ByteBuffer)buffer);
                    if (inputStream != null) {
                        objectStream = new ObjectInputStream(inputStream);
                        obj = objectStream.readObject();
                    }
                }
                catch (Exception ex) {
                    this.getLogger().error((Throwable)ex, "", new Object[0]);
                    try {
                        try {
                            if (inputStream != null) {
                                inputStream.reset();
                            }
                            break block23;
                        }
                        catch (IOException ex2) {
                            this.getLogger().error((Throwable)ex2, "Error resetting inputstream for attrId:[%s] gammaId:[%s]", new Object[]{this.getId(), this.getGammaId()});
                            Lib.close((AutoCloseable)objectStream);
                        }
                        break block23;
                    }
                    finally {
                        Lib.close((AutoCloseable)objectStream);
                    }
                }
            }
            catch (Throwable throwable) {
                block25: {
                    try {
                        try {
                            if (inputStream != null) {
                                inputStream.reset();
                            }
                        }
                        catch (IOException ex) {
                            this.getLogger().error((Throwable)ex, "Error resetting inputstream for attrId:[%s] gammaId:[%s]", new Object[]{this.getId(), this.getGammaId()});
                            Lib.close((AutoCloseable)objectStream);
                            break block25;
                        }
                    }
                    catch (Throwable throwable2) {
                        Lib.close(objectStream);
                        throw throwable2;
                    }
                    Lib.close(objectStream);
                }
                throw throwable;
            }
            try {
                try {
                    if (inputStream != null) {
                        inputStream.reset();
                    }
                }
                catch (IOException ex) {
                    this.getLogger().error((Throwable)ex, "Error resetting inputstream for attrId:[%s] gammaId:[%s]", new Object[]{this.getId(), this.getGammaId()});
                    Lib.close((AutoCloseable)objectStream);
                }
            }
            finally {
                Lib.close((AutoCloseable)objectStream);
            }
        }
        return obj;
    }

    @Override
    public boolean subClassSetValue(Object value) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            objectStream.writeObject(value);
            objectStream.flush();
            objectStream.close();
            this.getDataProxy().setValue(ByteBuffer.wrap(byteStream.toByteArray()));
            this.getDataProxy().setDisplayableString(value != null ? value.getClass().getName() : "null");
        }
        catch (Exception ex) {
            this.getLogger().error((Throwable)ex, "Error setting value", new Object[0]);
        }
        return true;
    }

    @Override
    public Object convertStringToValue(String value) {
        if (value == null) {
            return null;
        }
        return this.getObjectFromBytes(ByteBuffer.wrap(value.getBytes()));
    }
}

