/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.exception.AttributeDoesNotExist;
import org.eclipse.osee.framework.core.exception.MultipleAttributesExist;
import org.eclipse.osee.framework.jdk.core.type.BaseId;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.MultipleItemsExist;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.Attribute;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.HasOrcsData;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeExceptionFactory;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeFactory;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeManager;
import org.eclipse.osee.orcs.core.internal.util.MultiplicityState;
import org.eclipse.osee.orcs.core.internal.util.OrcsPredicates;

public abstract class AttributeManagerImpl
extends BaseId
implements HasOrcsData<ArtifactTypeToken, ArtifactData>,
AttributeManager,
AttributeExceptionFactory,
Iterable<Map.Entry<AttributeTypeId, List<Attribute<Object>>>> {
    private final HashCollection<AttributeTypeId, Attribute<Object>> attributes;
    private final String guid;
    private boolean isLoaded;
    private final AttributeFactory attributeFactory;

    protected AttributeManagerImpl(ArtifactData artifactData, AttributeFactory attributeFactory) {
        super(artifactData.getId());
        this.attributeFactory = attributeFactory;
        this.attributes = new HashCollection(true);
        this.guid = artifactData.getGuid();
    }

    private List<Attribute<Object>> filterAttributes(List<Attribute<Object>> attributes, DeletionFlag deletionFlag) {
        if (attributes == null) {
            return Collections.emptyList();
        }
        if (deletionFlag == DeletionFlag.INCLUDE_DELETED) {
            return attributes;
        }
        ArrayList<Attribute<Object>> notDeleted = new ArrayList<Attribute<Object>>(attributes.size());
        for (Attribute<Object> attr : attributes) {
            if (attr.isDeleted()) continue;
            notDeleted.add(attr);
        }
        return notDeleted;
    }

    @Override
    public synchronized void add(AttributeTypeToken attributeType, Attribute<?> attribute) {
        this.attributes.put((Object)attributeType, attribute);
        ((AttributeData)attribute.getOrcsData()).setArtifactId((ArtifactId)this);
    }

    @Override
    public synchronized void remove(AttributeTypeToken type, Attribute<?> attribute) {
        this.attributes.removeValue((Object)type, attribute);
        ((AttributeData)attribute.getOrcsData()).setArtifactId(ArtifactId.SENTINEL);
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Override
    public void setLoaded(boolean value) {
        this.isLoaded = value;
        if (value) {
            this.onLoaded();
        }
    }

    @Override
    public void setAttributesNotDirty() {
        for (Attribute attribute : this.attributes.getValues()) {
            attribute.clearDirty();
        }
    }

    @Override
    public boolean areAttributesDirty() {
        for (Attribute attr : this.attributes.getValues()) {
            if (!attr.isDirty()) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        String name;
        try {
            name = this.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.Name);
        }
        catch (Exception ex) {
            name = Lib.exceptionToString((Exception)ex);
        }
        return name;
    }

    @Override
    public Collection<AttributeTypeToken> getExistingAttributeTypes() {
        HashSet<AttributeTypeToken> notDeleted = new HashSet<AttributeTypeToken>();
        for (Attribute attr : this.attributes.getValues()) {
            if (attr.isDeleted()) continue;
            notDeleted.add(attr.getAttributeType());
        }
        return notDeleted;
    }

    public Attribute<Object> getAttributeById(AttributeId attributeId) {
        return this.getAttributeById(attributeId, DeletionFlag.EXCLUDE_DELETED);
    }

    public Attribute<Object> getAttributeById(AttributeId attributeId, DeletionFlag deletionFlag) {
        Attribute attribute = null;
        Optional tryFind = Iterables.tryFind(this.getAttributes(deletionFlag), OrcsPredicates.attributeId(attributeId));
        if (!tryFind.isPresent()) {
            throw new AttributeDoesNotExist("Attribute[%s] does not exist for %s", new Object[]{attributeId, this.getExceptionString()});
        }
        attribute = (Attribute)tryFind.get();
        return attribute;
    }

    @Override
    public List<Attribute<Object>> getAttributes() {
        return this.filterAttributes(this.attributes.getValues(), DeletionFlag.EXCLUDE_DELETED);
    }

    @Override
    public List<Attribute<Object>> getAttributes(DeletionFlag deletionFlag) {
        return this.filterAttributes(this.attributes.getValues(), deletionFlag);
    }

    @Override
    public <T> List<Attribute<T>> getAttributes(AttributeTypeId attributeType) {
        return this.getAttributes(attributeType, DeletionFlag.EXCLUDE_DELETED);
    }

    @Override
    public <T> List<Attribute<T>> getAttributes(AttributeTypeId attributeType, DeletionFlag deletionFlag) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll(this.filterAttributes((List)this.attributes.getValues((Object)attributeType), deletionFlag));
    }

    @Override
    public int getAttributeCount(AttributeTypeToken attributeType) {
        return this.getAttributeCount(attributeType, DeletionFlag.EXCLUDE_DELETED);
    }

    @Override
    public int getAttributeCount(AttributeTypeToken attributeType, DeletionFlag deletionFlag) {
        return this.filterAttributes((List)this.attributes.getValues((Object)attributeType), deletionFlag).size();
    }

    @Override
    public <T> List<T> getAttributeValues(AttributeTypeId attributeType) {
        List<Attribute<T>> attributes = this.getAttributes(attributeType);
        LinkedList<Object> values = new LinkedList<Object>();
        for (Attribute<T> attribute : attributes) {
            Object value = attribute.getValue();
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public String getSoleAttributeAsString(AttributeTypeId attributeType, String defaultValue) {
        String toReturn = defaultValue;
        List items = this.getAttributes(attributeType);
        if (!items.isEmpty()) {
            Attribute firstItem = items.iterator().next();
            toReturn = String.valueOf(firstItem.getValue());
        }
        return toReturn;
    }

    @Override
    public String getSoleAttributeAsString(AttributeTypeId attributeType) {
        String toReturn = null;
        Object value = this.getSoleAttributeValue(attributeType);
        if (value instanceof InputStream) {
            InputStream inputStream = (InputStream)value;
            try {
                try {
                    toReturn = Lib.inputStreamToString((InputStream)inputStream);
                }
                catch (IOException ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex2) {
                        OseeCoreException.wrapAndThrow((Throwable)ex2);
                    }
                }
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                }
            }
        } else if (value != null) {
            toReturn = value.toString();
        }
        return toReturn;
    }

    @Override
    public <T> T getSoleAttributeValue(AttributeTypeId attributeType) {
        Attribute<T> attribute = this.getSoleAttribute(attributeType);
        return (T)attribute.getValue();
    }

    @Override
    public <T> T getSoleAttributeValue(AttributeTypeId attributeType, DeletionFlag flag, T defaultValue) {
        Object value = defaultValue;
        Attribute<T> attribute = null;
        try {
            attribute = this.getSoleAttribute(attributeType, flag);
            value = attribute.getValue();
        }
        catch (AttributeDoesNotExist attributeDoesNotExist) {}
        return value;
    }

    @Override
    public <T> T getSoleAttributeValue(AttributeTypeId attributeType, T defaultValue) {
        Object value = defaultValue;
        Attribute<T> attribute = null;
        try {
            attribute = this.getSoleAttribute(attributeType);
            value = attribute.getValue();
            if (value == null) {
                return defaultValue;
            }
        }
        catch (AttributeDoesNotExist attributeDoesNotExist) {}
        return value;
    }

    @Override
    public <T> void setSoleAttributeValue(AttributeTypeToken attributeType, T value) {
        Attribute<Object> attribute = this.getOrCreateSoleAttribute(attributeType);
        attribute.setValue(value);
    }

    @Override
    public void setSoleAttributeFromString(AttributeTypeToken attributeType, String value) {
        this.getOrCreateSoleAttribute(attributeType).setFromString(value);
    }

    @Override
    public void setSoleAttributeFromStream(AttributeTypeToken attributeType, InputStream inputStream) {
        this.getOrCreateSoleAttribute(attributeType).setValueFromInputStream(inputStream);
    }

    @Override
    public void setAttributesFromStrings(AttributeTypeToken attributeType, String ... values) {
        this.setAttributesFromStrings(attributeType, Arrays.asList(values));
    }

    @Override
    public void setAttributesFromStrings(AttributeTypeToken attributeType, Collection<String> values) {
        LinkedHashSet<String> uniqueItems = new LinkedHashSet<String>(values);
        List remainingAttributes = this.getAttributes((AttributeTypeId)attributeType);
        ArrayList<String> remainingNewValues = new ArrayList<String>(uniqueItems.size());
        for (String string : uniqueItems) {
            boolean found = false;
            for (Attribute attribute : remainingAttributes) {
                if (!string.equals(attribute.getValue().toString())) continue;
                remainingAttributes.remove(attribute);
                found = true;
                break;
            }
            if (found) continue;
            remainingNewValues.add(string);
        }
        for (String string : remainingNewValues) {
            Attribute attribute;
            if (remainingAttributes.isEmpty()) {
                this.createAttributeFromString(attributeType, string);
                continue;
            }
            int index = remainingAttributes.size() - 1;
            attribute = remainingAttributes.get(index);
            attribute.setFromString(string);
            remainingAttributes.remove(index);
        }
        for (Attribute attribute : remainingAttributes) {
            attribute.delete();
        }
    }

    @Override
    public <T> void setAttributesFromValues(AttributeTypeToken attributeType, Collection<T> values) {
        LinkedHashSet<T> uniqueItems = new LinkedHashSet<T>(values);
        List<Attribute<T>> remainingAttributes = this.getAttributes((AttributeTypeId)attributeType);
        ArrayList remainingNewValues = new ArrayList(uniqueItems.size());
        for (Object e : uniqueItems) {
            boolean found = false;
            for (Attribute<T> attribute : remainingAttributes) {
                if (!e.equals(attribute.getValue())) continue;
                remainingAttributes.remove(attribute);
                found = true;
                break;
            }
            if (found) continue;
            remainingNewValues.add(e);
        }
        for (Object e : remainingNewValues) {
            Attribute<T> attribute;
            if (remainingAttributes.isEmpty()) {
                this.createAttribute(attributeType, e);
                continue;
            }
            int index = remainingAttributes.size() - 1;
            attribute = remainingAttributes.get(index);
            attribute.setValue(e);
            remainingAttributes.remove(index);
        }
        for (Attribute attribute : remainingAttributes) {
            attribute.delete();
        }
    }

    @Override
    public void deleteAttributesByArtifact() {
        for (Attribute attribute : this.attributes.getValues()) {
            attribute.setArtifactDeleted();
        }
    }

    @Override
    public void unDeleteAttributesByArtifact() {
        for (Attribute attribute : this.attributes.getValues()) {
            if (ModificationType.ARTIFACT_DELETED != attribute.getModificationType()) continue;
            attribute.unDelete();
        }
    }

    @Override
    public void deleteSoleAttribute(AttributeTypeId attributeType) {
        Attribute attribute = this.getSoleAttribute(attributeType);
        if (attribute != null) {
            this.deleteAttribute(attribute);
        }
    }

    @Override
    public void deleteAttributes(AttributeTypeId attributeType) {
        List values = (List)this.attributes.getValues((Object)attributeType);
        if (values == null) {
            return;
        }
        for (Attribute attribute : values) {
            attribute.delete();
        }
    }

    @Override
    public void deleteAttributesWithValue(AttributeTypeId attributeType, Object value) {
        List values = (List)this.attributes.getValues((Object)attributeType);
        if (values == null) {
            return;
        }
        for (Attribute attribute : values) {
            if (!attribute.getValue().equals(value)) continue;
            this.deleteAttribute(attribute);
            break;
        }
    }

    private void deleteAttribute(Attribute<?> attribute) {
        this.checkMultiplicityCanDelete(attribute.getAttributeType());
        attribute.delete();
    }

    @Override
    public <T> Attribute<T> createAttribute(AttributeTypeToken attributeType) {
        this.checkTypeValid(attributeType);
        this.checkMultiplicityCanAdd(attributeType);
        Attribute attr = this.attributeFactory.createAttributeWithDefaults(this, (ArtifactData)this.getOrcsData(), attributeType);
        return attr;
    }

    @Override
    public <T> Attribute<T> createAttribute(AttributeTypeToken attributeType, T value) {
        Attribute<T> attribute = this.createAttribute(attributeType);
        attribute.setValue(value);
        return attribute;
    }

    private <T> Attribute<T> createAttributeFromString(AttributeTypeToken attributeType, String value) {
        Attribute<T> attribute = this.createAttribute(attributeType);
        attribute.setFromString(value);
        return attribute;
    }

    @Override
    public Iterator<Map.Entry<AttributeTypeId, List<Attribute<Object>>>> iterator() {
        return this.attributes.iterator();
    }

    private Attribute<Object> getOrCreateSoleAttribute(AttributeTypeToken attributeType) {
        List filterAttributes = this.getAttributes((AttributeTypeId)attributeType);
        int count = filterAttributes.size();
        if (count > 1) {
            throw new MultipleItemsExist("Multiple items found - total [%s]", new Object[]{count});
        }
        if (count == 1) {
            return filterAttributes.iterator().next();
        }
        return this.createAttribute(attributeType);
    }

    @Override
    public <T> Attribute<T> getSoleAttribute(AttributeTypeId attributeType) {
        return this.getSoleAttribute(attributeType, DeletionFlag.EXCLUDE_DELETED);
    }

    @Override
    public <T> Attribute<T> getSoleAttribute(AttributeTypeId attributeType, DeletionFlag flag) {
        List<Attribute<T>> filterAttributes = this.getAttributes(attributeType, flag);
        int size = filterAttributes.size();
        if (size == 1) {
            return (Attribute)filterAttributes.iterator().next();
        }
        if (size < 1) {
            throw this.createDoesNotExistException(attributeType);
        }
        throw this.createManyExistException(attributeType, size);
    }

    private void checkTypeValid(AttributeTypeToken attributeType) {
        if (CoreAttributeTypes.Name.notEqual((Id)attributeType) && !this.isAttributeTypeValid(attributeType)) {
            throw new OseeArgumentException("The attribute type [%s] is not valid for artifacts [%s]", new Object[]{attributeType, this.getExceptionString()});
        }
    }

    private void checkMultiplicityCanAdd(AttributeTypeToken attributeType) {
        this.checkMultiplicity((AttributeTypeId)attributeType, this.getAttributeCount(attributeType) + 1);
    }

    private void checkMultiplicityCanDelete(AttributeTypeToken attributeType) {
        this.checkMultiplicity((AttributeTypeId)attributeType, this.getAttributeCount(attributeType) - 1);
    }

    private void checkMultiplicity(AttributeTypeId attributeType, int count) {
        MultiplicityState state = this.getAttributeMuliplicityState(attributeType, count);
        switch (state) {
            case MAX_VIOLATION: {
                throw new OseeStateException("Attribute type [%s] exceeds max occurrence rule on [%s]", new Object[]{attributeType, this.getExceptionString()});
            }
            case MIN_VIOLATION: {
                throw new OseeStateException("Attribute type [%s] is less than min occurrence rule on [%s]", new Object[]{attributeType, this.getExceptionString()});
            }
        }
    }

    private MultiplicityState getAttributeMuliplicityState(AttributeTypeId attributeType, int count) {
        MultiplicityState state = MultiplicityState.IS_VALID;
        if (count > this.attributeFactory.getMaxOccurrenceLimit(attributeType)) {
            state = MultiplicityState.MAX_VIOLATION;
        } else if (count < this.attributeFactory.getMinOccurrenceLimit(attributeType)) {
            state = MultiplicityState.MIN_VIOLATION;
        }
        return state;
    }

    private void onLoaded() {
        this.meetMinimumAttributes();
    }

    private void meetMinimumAttributes() {
        for (AttributeTypeToken attributeType : this.getValidAttributeTypes()) {
            int missingCount = this.getRemainingAttributeCount(attributeType);
            int i = 0;
            while (i < missingCount) {
                this.attributeFactory.createAttributeWithDefaults(this, (ArtifactData)this.getOrcsData(), attributeType);
                ++i;
            }
        }
    }

    private final int getRemainingAttributeCount(AttributeTypeToken attributeType) {
        int minLimit = this.attributeFactory.getMinOccurrenceLimit((AttributeTypeId)attributeType);
        return minLimit - this.getAttributeCount(attributeType);
    }

    @Override
    public MultipleAttributesExist createManyExistException(AttributeTypeId type, int count) {
        MultipleAttributesExist toReturn = type != null ? new MultipleAttributesExist("The attribute type [%s] has [%s] instances on [%s], but only [1] instance is allowed", new Object[]{type, count, this.getExceptionString()}) : new MultipleAttributesExist("Multiple items found - total instances [%s] on [%s], but only [1] instance is allowed", new Object[]{count, this.getExceptionString()});
        return toReturn;
    }

    @Override
    public AttributeDoesNotExist createDoesNotExistException(AttributeTypeId type) {
        AttributeDoesNotExist toReturn = type == null ? new AttributeDoesNotExist("Attribute could not be found on [%s]", new Object[]{this.getExceptionString()}) : new AttributeDoesNotExist("Attribute of type [%s] could not be found on [%s]", new Object[]{type, this.getExceptionString()});
        return toReturn;
    }

    public String getGuid() {
        return this.guid;
    }
}

