/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.SystemPreferences;
import org.eclipse.osee.orcs.core.ds.KeyValueDataAccessor;

public class SystemPreferencesImpl
implements SystemPreferences {
    private static Map<String, Pair<Long, String>> cache;
    private KeyValueDataAccessor accessor;

    public void setDataAccessor(KeyValueDataAccessor accessor) {
        this.accessor = accessor;
    }

    public void start() {
        cache = new ConcurrentHashMap<String, Pair<Long, String>>();
    }

    public void stop() {
        cache = null;
    }

    public String getSystemUuid() {
        return this.getValue("osee.db.guid");
    }

    public String getValue(String key) {
        String toReturn = this.accessor.getValue(key);
        SystemPreferencesImpl.cacheValue(key, toReturn);
        return toReturn;
    }

    public String getCachedValue(String key) {
        return this.getCachedValue(key, Integer.MAX_VALUE);
    }

    public String getCachedValue(String key, String defaultValue) {
        String value;
        try {
            value = this.getCachedValue(key);
            if (Strings.isInValid((String)value)) {
                value = defaultValue;
            }
        }
        catch (Exception exception) {
            value = defaultValue;
        }
        return value;
    }

    public String getCachedValue(String key, long maxStaleness) {
        Pair<Long, String> pair = cache.get(key);
        String value = pair == null || (Long)pair.getFirst() + maxStaleness < System.currentTimeMillis() ? this.getValue(key) : (String)pair.getSecond();
        return value;
    }

    public boolean isEnabled(String key) {
        return this.isBoolean(key);
    }

    public boolean isCacheEnabled(String key) {
        String dbProperty = this.getCachedValue(key);
        if (Strings.isValid((String)dbProperty)) {
            return dbProperty.equals("true");
        }
        return false;
    }

    public void setEnabled(String key, boolean enabled) {
        this.setBoolean(key, enabled);
    }

    public void setBoolean(String key, boolean value) {
        this.putValue(key, String.valueOf(value));
    }

    public boolean isBoolean(String key) {
        String dbProperty = this.getValue(key);
        if (Strings.isValid((String)dbProperty)) {
            return dbProperty.equals("true");
        }
        return false;
    }

    public boolean isBooleanUsingCache(String key) {
        return this.isCacheEnabled(key);
    }

    public void putValue(String key, String value) {
        this.accessor.putValue(key, value);
        SystemPreferencesImpl.cacheValue(key, value);
    }

    public Set<String> getKeys() {
        return this.accessor.getKeys();
    }

    private static void cacheValue(String key, String value) {
        Long time = System.currentTimeMillis();
        cache.put(key, (Pair<Long, String>)new Pair((Object)time, (Object)value));
    }
}

