/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.dsl.integration.internal;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.dsl.integration.ArtifactDataProvider;
import org.eclipse.osee.framework.core.dsl.integration.RestrictionHandler;
import org.eclipse.osee.framework.core.dsl.integration.internal.ArtifactMatchInterpreter;
import org.eclipse.osee.framework.core.dsl.integration.internal.OseeUtil;
import org.eclipse.osee.framework.core.dsl.oseeDsl.ObjectRestriction;
import org.eclipse.osee.framework.core.dsl.oseeDsl.RelationTypeArtifactPredicate;
import org.eclipse.osee.framework.core.dsl.oseeDsl.RelationTypeArtifactTypePredicate;
import org.eclipse.osee.framework.core.dsl.oseeDsl.RelationTypePredicate;
import org.eclipse.osee.framework.core.dsl.oseeDsl.RelationTypeRestriction;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XArtifactMatcher;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XArtifactType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XRelationSideEnum;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XRelationType;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.model.access.AccessDetail;
import org.eclipse.osee.framework.core.model.access.AccessDetailCollector;
import org.eclipse.osee.framework.core.model.access.Scope;
import org.eclipse.osee.framework.core.model.type.RelationType;

public class RelationTypeRestrictionHandler
implements RestrictionHandler<RelationTypeRestriction> {
    private final ArtifactMatchInterpreter matcherInterpreter;

    public RelationTypeRestrictionHandler(ArtifactMatchInterpreter matcherInterpreter) {
        this.matcherInterpreter = matcherInterpreter;
    }

    @Override
    public RelationTypeRestriction asCastedObject(ObjectRestriction objectRestriction) {
        RelationTypeRestriction toReturn = null;
        if (objectRestriction instanceof RelationTypeRestriction) {
            toReturn = (RelationTypeRestriction)objectRestriction;
        }
        return toReturn;
    }

    @Override
    public void process(ObjectRestriction objectRestriction, ArtifactDataProvider.ArtifactProxy artifactProxy, AccessDetailCollector collector, Scope scope) {
        RelationTypeRestriction restriction = this.asCastedObject(objectRestriction);
        if (restriction != null) {
            ArtifactTypeToken ruleType;
            RelationTypeArtifactTypePredicate artifactTypePredicate;
            XArtifactType artifactTypeRef;
            XRelationSideEnum restrictedSide = restriction.getRestrictedToSide();
            Scope toUse = scope;
            RelationTypePredicate predicate = restriction.getPredicate();
            if (predicate instanceof RelationTypeArtifactPredicate) {
                RelationTypeArtifactPredicate artifactPredicate = (RelationTypeArtifactPredicate)predicate;
                XArtifactMatcher artifactMatcher = artifactPredicate.getArtifactMatcherRef();
                if (artifactMatcher != null && this.matcherInterpreter != null && this.matcherInterpreter.matches(artifactMatcher, artifactProxy)) {
                    toUse = scope.clone().addSubPath(artifactProxy.getName());
                }
            } else if (predicate instanceof RelationTypeArtifactTypePredicate && (artifactTypeRef = (artifactTypePredicate = (RelationTypeArtifactTypePredicate)predicate).getArtifactTypeRef()) != null && artifactProxy.isOfType(new ArtifactTypeId[]{ruleType = ArtifactTypeToken.valueOf((long)Long.valueOf(artifactTypeRef.getId()), (String)artifactTypeRef.getName(), (ArtifactTypeToken[])new ArtifactTypeToken[0])})) {
                toUse = scope.clone().addSubPath(artifactProxy.getName());
            }
            Collection<RelationType> relationTypes = this.getRelationTypes(artifactProxy, restriction);
            PermissionEnum permission = OseeUtil.getPermission((ObjectRestriction)restriction);
            for (RelationType relationType : relationTypes) {
                RelationSide[] relationSideArray = RelationSide.values();
                int n = relationSideArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RelationSide relationSide = relationSideArray[n2];
                    if (OseeUtil.isRestrictedSide(restrictedSide, relationSide)) {
                        collector.collect(new AccessDetail((Object)new RelationTypeSide((RelationTypeToken)relationType, relationSide), permission, toUse));
                    }
                    ++n2;
                }
            }
        }
    }

    private Collection<RelationType> getRelationTypes(ArtifactDataProvider.ArtifactProxy artifactProxy, RelationTypeRestriction restriction) {
        XRelationType xRelationType;
        IRelationType typeToMatch;
        RelationType relationType;
        Collection<Object> types = restriction.isRelationTypeMatch() ? artifactProxy.getValidRelationTypes() : ((relationType = this.getRelationType(typeToMatch = OseeUtil.toToken(xRelationType = restriction.getRelationTypeRef()), artifactProxy)) != null ? Collections.singleton(relationType) : Collections.emptyList());
        return types;
    }

    private RelationType getRelationType(IRelationType typeToMatch, ArtifactDataProvider.ArtifactProxy artifactProxy) {
        RelationType toReturn = null;
        Collection<RelationType> relationTypes = artifactProxy.getValidRelationTypes();
        for (RelationType relationType : relationTypes) {
            if (!relationType.equals((Object)typeToMatch)) continue;
            toReturn = relationType;
            break;
        }
        return toReturn;
    }
}

