/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.define.api.importing;

import java.util.regex.Matcher;
import org.eclipse.define.api.importing.BlockFieldToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class BlockField {
    protected String data;
    protected final BlockFieldToken bft;

    public BlockField(BlockFieldToken bft) {
        this.bft = bft;
        this.data = "";
    }

    public Boolean fillContent(String content) {
        Boolean match = false;
        Conditions.assertNotNullOrEmpty((String)content, (String)"null content in add content to block", (Object[])new Object[0]);
        String strippedContent = content.replaceAll("<[^>]+>", "");
        Matcher contentMatcher = this.bft.contentRegex.matcher(strippedContent);
        if (contentMatcher.find()) {
            this.data = contentMatcher.group(1);
            match = true;
        } else {
            this.data = "";
        }
        return match;
    }

    public void appendContent(String content, boolean first) {
        String newline = "";
        if (!first) {
            newline = "\n";
        }
        this.data = String.valueOf(this.data) + newline + content;
    }

    public String getImportTypeName() {
        return this.bft.getName();
    }

    public Long getId() {
        return this.bft.getId();
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public AttributeTypeToken getOseeType() {
        return this.bft.getOseeType();
    }
}

