/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.TransactionTokenDeserializer;
import org.eclipse.osee.framework.core.data.TransactionTokenSerializer;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.data.UserTokenDeserializer;
import org.eclipse.osee.framework.core.data.UserTokenSerializer;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.jdk.core.type.IdDeserializer;
import org.eclipse.osee.framework.jdk.core.type.IdSerializer;
import org.eclipse.osee.framework.jdk.core.type.NamedIdDeserializer;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class JsonUtil {
    private static ObjectMapper mapper = JsonUtil.createObjectMapper().setDateFormat((DateFormat)new SimpleDateFormat("MMM d, yyyy h:mm:ss aa"));
    private static ObjectMapper mapper2 = JsonUtil.createObjectMapper().setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm a z"));

    public static synchronized ObjectMapper getMapper() {
        return mapper;
    }

    public static JsonNode readTree(String json) {
        try {
            return JsonUtil.getMapper().readTree(json);
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public static String toJson(Object object) {
        try {
            return JsonUtil.getMapper().writeValueAsString(object);
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public static <T> T readValue(String content, Class<T> valueType) {
        try {
            return (T)JsonUtil.getMapper().readValue(content, valueType);
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private static synchronized ObjectMapper getMapperZ() {
        return mapper2;
    }

    public static JsonFactory getFactory() {
        return JsonUtil.getMapperZ().getFactory();
    }

    public static JsonNode getArrayElement(JsonNode array, String key, String value) {
        for (JsonNode element : array) {
            JsonNode node = element.get(key);
            if (node == null || !value.equals(node.asText())) continue;
            return element;
        }
        return null;
    }

    public static JsonNode getJsonParserTree(JsonParser jp) {
        try {
            return (JsonNode)jp.getCodec().readTree(jp);
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public static <T> T readValue(String json, TypeReference<Map<String, String>> typeReference) {
        try {
            return (T)JsonUtil.getMapper().readValue(json, typeReference);
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, false);
        objectMapper.configure(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, true);
        objectMapper.configure(MapperFeature.AUTO_DETECT_CREATORS, true);
        objectMapper.configure(MapperFeature.AUTO_DETECT_FIELDS, true);
        objectMapper.configure(MapperFeature.AUTO_DETECT_FIELDS, true);
        objectMapper.configure(MapperFeature.AUTO_DETECT_GETTERS, true);
        objectMapper.configure(MapperFeature.AUTO_DETECT_IS_GETTERS, true);
        objectMapper.configure(MapperFeature.AUTO_DETECT_SETTERS, true);
        objectMapper.configure(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        objectMapper.configure(MapperFeature.USE_ANNOTATIONS, true);
        objectMapper.configure(MapperFeature.USE_ANNOTATIONS, true);
        objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        objectMapper.configure(SerializationFeature.WRAP_EXCEPTIONS, true);
        objectMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        objectMapper.configure(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS, true);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true);
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
        prettyPrinter.indentObjectsWith((DefaultPrettyPrinter.Indenter)new DefaultIndenter("  ", "\n"));
        objectMapper.setDefaultPrettyPrinter((PrettyPrinter)prettyPrinter);
        SimpleModule module = new SimpleModule("OSEE", new Version(1, 0, 0, "", "", ""));
        module.addDeserializer(ApplicabilityToken.class, (JsonDeserializer)new NamedIdDeserializer(ApplicabilityToken::valueOf));
        module.addDeserializer(ArtifactToken.class, (JsonDeserializer)new NamedIdDeserializer(ArtifactToken::valueOf));
        module.addDeserializer(ArtifactId.class, (JsonDeserializer)new IdDeserializer(ArtifactId::valueOf));
        module.addDeserializer(TransactionToken.class, (JsonDeserializer)new TransactionTokenDeserializer());
        module.addSerializer(TransactionToken.class, (JsonSerializer)new TransactionTokenSerializer());
        module.addDeserializer(UserToken.class, (JsonDeserializer)new UserTokenDeserializer());
        module.addSerializer(UserToken.class, (JsonSerializer)new UserTokenSerializer());
        IdSerializer idSerializer = new IdSerializer();
        module.addSerializer(TransactionId.class, (JsonSerializer)idSerializer);
        module.addSerializer(BranchType.class, (JsonSerializer)idSerializer);
        module.addSerializer(BranchState.class, (JsonSerializer)idSerializer);
        module.addDeserializer(TransactionId.class, (JsonDeserializer)new IdDeserializer(TransactionId::valueOf));
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }
}

