/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.enums;

import java.util.HashMap;
import java.util.Map;

public enum PermissionEnum {
    NONE(5, "None", "Open Access for all Users"),
    READ(10, "Read", "Read only access for specified user"),
    WRITE(20, "Write", "Write access for specified user"),
    LOCK(25, "Lock", "Locked for write by only the specified user"),
    FULLACCESS(30, "Full Access", "Full Access to Read, Write and Change Permissions"),
    DENY(65535, "Deny", "Deny all access.  Usually only if something is ");

    private static final int COUNT = 4;
    private static final Map<Integer, PermissionEnum> rankToPermissionHash;
    private static final Map<String, PermissionEnum> NameToPermissionHash;
    private static final String[] NAME_ARRAY;
    private int permissionId;
    private String name;
    public boolean add;
    private final String description;

    static {
        rankToPermissionHash = new HashMap<Integer, PermissionEnum>(6, 0.75f);
        NameToPermissionHash = new HashMap<String, PermissionEnum>(6, 0.75f);
        NAME_ARRAY = new String[PermissionEnum.values().length];
        int i = 0;
        PermissionEnum[] permissionEnumArray = PermissionEnum.values();
        int n = permissionEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            PermissionEnum permission = permissionEnumArray[n2];
            rankToPermissionHash.put(permission.getPermId(), permission);
            NameToPermissionHash.put(permission.getName(), permission);
            PermissionEnum.NAME_ARRAY[i++] = permission.getName();
            ++n2;
        }
    }

    public String getDescription() {
        return this.description;
    }

    private PermissionEnum(int permissionId, String name, String description) {
        this.permissionId = permissionId;
        this.name = name;
        this.description = description;
    }

    public int getRank() {
        return this.permissionId;
    }

    public String getName() {
        return this.name;
    }

    public static PermissionEnum getPermission(int permissionId) {
        if (permissionId == 40) {
            return LOCK;
        }
        return rankToPermissionHash.get(permissionId);
    }

    public static PermissionEnum getPermission(String name) {
        return NameToPermissionHash.get(name);
    }

    public boolean matches(PermissionEnum toMatch) {
        boolean hasPermission = false;
        hasPermission = toMatch == READ && this == LOCK ? true : (toMatch == null || this == LOCK ? false : this.getRank() >= toMatch.getRank() && !this.equals((Object)DENY));
        return hasPermission;
    }

    public static PermissionEnum getMostRestrictive(PermissionEnum perm1, PermissionEnum perm2) {
        PermissionEnum net = null;
        if (perm1 == DENY || perm2 == DENY) {
            net = DENY;
        } else if (perm1 == LOCK || perm2 == LOCK) {
            net = LOCK;
        } else {
            PermissionEnum object1 = perm1 == null ? NONE : perm1;
            PermissionEnum object2 = perm2 == null ? NONE : perm2;
            net = object1.matches(object2) ? object2 : object1;
        }
        return net;
    }

    public static String[] getPermissionNames() {
        return NAME_ARRAY;
    }

    public int getPermId() {
        return this.permissionId;
    }
}

