/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.internal.fields;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.model.AbstractOseeField;
import org.eclipse.osee.framework.core.model.type.AttributeType;
import org.eclipse.osee.framework.jdk.core.util.Compare;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public final class ArtifactTypeAttributesField
extends AbstractOseeField<Map<BranchId, Collection<AttributeType>>> {
    private final Map<BranchId, Collection<AttributeType>> validityMap;

    public ArtifactTypeAttributesField(Map<BranchId, Collection<AttributeType>> validityMap) {
        this.validityMap = validityMap;
    }

    @Override
    public Map<BranchId, Collection<AttributeType>> get() {
        return new HashMap<BranchId, Collection<AttributeType>>(this.validityMap);
    }

    public void put(BranchId branch, Collection<AttributeType> attributes) {
        Collection<AttributeType> current = this.validityMap.get(branch);
        this.validityMap.put(branch, attributes);
        if (Compare.isDifferent(current, attributes)) {
            this.isDirty = true;
        }
    }

    @Override
    public void set(Map<BranchId, Collection<AttributeType>> attributeTypeMap) {
        Conditions.checkNotNull(attributeTypeMap, (String)"attribute type map input");
        boolean isDifferent = Compare.isDifferent((Object)this.get(), attributeTypeMap);
        if (isDifferent) {
            this.validityMap.clear();
            for (Map.Entry<BranchId, Collection<AttributeType>> entry : attributeTypeMap.entrySet()) {
                this.set(entry.getKey(), entry.getValue());
            }
        }
        this.isDirty |= isDifferent;
    }

    private void set(BranchId branch, Collection<AttributeType> attributeTypes) {
        Conditions.checkNotNull((Object)branch, (String)"branch");
        Conditions.checkNotNull(attributeTypes, (String)"attribute types list");
        if (attributeTypes.isEmpty()) {
            this.validityMap.remove(branch);
        } else {
            Collection<AttributeType> cachedItems = this.validityMap.get(branch);
            if (cachedItems == null) {
                cachedItems = new HashSet<AttributeType>(attributeTypes);
                this.validityMap.put(branch, cachedItems);
            } else {
                cachedItems.clear();
                cachedItems.addAll(attributeTypes);
            }
        }
    }
}

