/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.core.enums.OseeCacheEnum;
import org.eclipse.osee.framework.core.model.cache.IOseeCache;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public abstract class AbstractOseeCache<T extends NamedIdBase>
implements IOseeCache<T> {
    private final ConcurrentHashMap<String, T> nameToTypeMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, T> idToTypeMap = new ConcurrentHashMap();
    private final OseeCacheEnum cacheId;

    protected AbstractOseeCache(OseeCacheEnum cacheId) {
        this.cacheId = cacheId;
    }

    @Override
    public synchronized void decacheAll() {
        this.nameToTypeMap.clear();
        this.idToTypeMap.clear();
    }

    @Override
    public OseeCacheEnum getCacheId() {
        return this.cacheId;
    }

    @Override
    public int size() {
        return this.idToTypeMap.size();
    }

    public boolean existsByName(String name) {
        this.ensurePopulated();
        return this.nameToTypeMap.containsKey(name);
    }

    @Override
    public void decache(T ... types) {
        Conditions.checkNotNull(types, (String)"types to de-cache");
        T[] TArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            T type = TArray[n2];
            this.decache(type);
            ++n2;
        }
    }

    @Override
    public void decache(T type) {
        Conditions.checkNotNull(type, (String)"type to de-cache");
        this.ensurePopulated();
        this.decacheByName(type);
        if (type.isValid()) {
            this.idToTypeMap.remove(type.getId());
        }
    }

    protected synchronized Collection<T> getRawValues() {
        this.ensurePopulated();
        return this.idToTypeMap.values();
    }

    private void decacheByName(T type) {
        Iterator<T> iterator = this.nameToTypeMap.values().iterator();
        while (iterator.hasNext()) {
            if (!((NamedIdBase)iterator.next()).equals(type)) continue;
            iterator.remove();
        }
    }

    @Override
    public void cache(T ... types) {
        Conditions.checkNotNull(types, (String)"types to cache");
        T[] TArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            T type = TArray[n2];
            this.cache(type);
            ++n2;
        }
    }

    @Override
    public void cache(T type) {
        Conditions.checkNotNull(type, (String)"type to cache");
        this.ensurePopulated();
        this.nameToTypeMap.put(type.getName(), type);
        this.idToTypeMap.putIfAbsent(type.getId(), type);
    }

    @Override
    public Collection<T> getAll() {
        this.ensurePopulated();
        return new ArrayList<T>(this.idToTypeMap.values());
    }

    @Override
    public T getById(Number typeId) {
        this.ensurePopulated();
        return (T)((NamedIdBase)this.idToTypeMap.get(typeId.longValue()));
    }

    public T getByName(String typeName) {
        this.ensurePopulated();
        NamedIdBase value = (NamedIdBase)this.nameToTypeMap.get(typeName);
        if (value == null) {
            throw new ItemDoesNotExist("Cache does not contain item with name [%s]", new Object[]{typeName});
        }
        return (T)value;
    }

    @Override
    public T getByGuid(Long id) {
        this.ensurePopulated();
        return (T)((NamedIdBase)this.idToTypeMap.get(id));
    }

    public T get(Id token) {
        this.ensurePopulated();
        return this.getByGuid(token.getId());
    }

    public void cacheFrom(AbstractOseeCache<T> source) {
        for (NamedIdBase type : source.getAll()) {
            this.cache((T)type);
        }
    }

    protected void ensurePopulated() {
    }
}

