/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util.health;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.health.HealthCheckResults;
import org.eclipse.osee.ats.api.util.health.IAtsHealthCheck;
import org.eclipse.osee.ats.api.util.health.IAtsHealthCheckProvider;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.rest.internal.util.health.AtsHealthCheckProviderService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.ILoggerListener;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.logging.SevereLoggingMonitor;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.mail.api.MailMessage;
import org.eclipse.osee.mail.api.MailService;

public class AtsHealthCheckOperation {
    private static String SELECT_INWORK_WORKFLOWS = "SELECT distinct art.art_id FROM osee_artifact art, osee_txs txs, OSEE_ATTRIBUTE attr WHERE attr.gamma_id = txs.gamma_id AND txs.tx_current = 1 AND txs.branch_id = 570 and attr.ART_ID = art.ART_ID and attr.ATTR_TYPE_ID = 1152921504606847147 and attr.VALUE = 'Working'";
    private final AtsApi atsApi;
    private final JdbcService jdbcService;
    private final MailService mailService;
    boolean inTest = false;

    public AtsHealthCheckOperation(AtsApi atsApi, JdbcService jdbcService, MailService mailService) {
        this.atsApi = atsApi;
        this.jdbcService = jdbcService;
        this.mailService = mailService;
    }

    public XResultData run() {
        XResultData rd = new XResultData();
        try {
            ElapsedTime time = new ElapsedTime("ATS Health Check");
            this.runIt(rd);
            String elapsedStr = time.end(ElapsedTime.Units.SEC);
            rd.log("\n\n" + elapsedStr);
            time.end();
            this.emailResults(rd);
        }
        catch (Exception ex) {
            rd.errorf("Exception running reports [%s]", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return rd;
    }

    private void emailResults(XResultData rd) {
        if (this.mailService != null) {
            MailMessage msg = MailMessage.newBuilder().from("noop@osee.com").recipients(Arrays.asList("donald.g.dunne@boeing.com")).subject("ATS Health Check").addHtml(AHTML.simplePage((String)rd.toString().replaceAll("\n", "</br>"))).build();
            List sendMessages = this.mailService.sendMessages(new MailMessage[]{msg});
            System.out.println(sendMessages);
        }
    }

    public void runIt(XResultData rd) {
        SevereLoggingMonitor monitorLog = new SevereLoggingMonitor();
        OseeLog.registerLoggerListener((ILoggerListener)monitorLog);
        int count = 0;
        HealthCheckResults vResults = new HealthCheckResults();
        if (this.inTest) {
            vResults.log("testMap1", "blah blah");
            vResults.log("testMap2", "blah blah");
            vResults.log("testMap1", "blah blah");
            vResults.log("testMap3", "blah blah");
        } else {
            List<IAtsHealthCheck> checks = this.getHealthChecks();
            List<Collection<Long>> artIdLists = this.loadWorkingWorkItemIds(rd);
            int numblocks = artIdLists.size();
            int x = 1;
            for (Collection<Long> artIdList : artIdLists) {
                System.err.println(String.format("processing %s / %s", x++, numblocks));
                Collection allArtifacts = this.atsApi.getQueryService().getArtifacts(artIdList);
                ArrayList<ArtifactId> artifacts = new ArrayList<ArtifactId>(allArtifacts.size());
                for (ArtifactId artifact : allArtifacts) {
                    if (this.atsApi.getStoreService().isDeleted(artifact)) continue;
                    artifacts.add(artifact);
                }
                count += artifacts.size();
                for (ArtifactId artifact : artifacts) {
                    for (IAtsHealthCheck check : checks) {
                        if (this.atsApi.getStoreService().isDeleted(artifact)) continue;
                        IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItem((ArtifactToken)artifact);
                        Date date = new Date();
                        try {
                            check.check(artifact, workItem, vResults, this.atsApi);
                        }
                        catch (Exception ex) {
                            vResults.log(artifact, check.getName(), "Error: Exception: " + Lib.exceptionToString((Exception)ex));
                        }
                        vResults.logTestTimeSpent(date, check.getName());
                    }
                }
            }
            checks = null;
        }
        vResults.addResultsMapToResultData(rd);
        vResults.addTestTimeMapToResultData(rd);
        rd.logf("Completed processing %s work items.", new Object[]{count});
    }

    private List<IAtsHealthCheck> getHealthChecks() {
        LinkedList<IAtsHealthCheck> healthChecks = new LinkedList<IAtsHealthCheck>();
        healthChecks.add(new TestTaskParent());
        healthChecks.add(new TestWorkflowTeamDefinition());
        healthChecks.add(new TestWorkflowVersions());
        healthChecks.add(new TestWorkflowDefinition());
        for (IAtsHealthCheckProvider provider : AtsHealthCheckProviderService.getHealthCheckProviders()) {
            healthChecks.addAll(provider.getHealthChecks());
        }
        return healthChecks;
    }

    private List<Collection<Long>> loadWorkingWorkItemIds(XResultData rd) {
        rd.log("testLoadAllCommonArtifactIds - Started " + DateUtil.getMMDDYYHHMM());
        List<Long> artIds = this.getCommonArtifactIds(rd);
        if (artIds.isEmpty()) {
            rd.error("Error: Artifact load returned 0 artifacts to check");
        }
        rd.log("testLoadAllCommonArtifactIds - Completed " + DateUtil.getMMDDYYHHMM());
        return Collections.subDivide(artIds, (int)4000);
    }

    private List<Long> getCommonArtifactIds(XResultData rd) {
        ArrayList<Long> artIds = new ArrayList<Long>();
        rd.log("getCommonArtifactIds - Started " + DateUtil.getMMDDYYHHMM());
        JdbcStatement chStmt = this.jdbcService.getClient().getStatement();
        try {
            chStmt.runPreparedQuery(SELECT_INWORK_WORKFLOWS, new Object[0]);
            while (chStmt.next()) {
                artIds.add(Long.valueOf(chStmt.getInt(1)));
            }
        }
        finally {
            chStmt.close();
            rd.log("getCommonArtifactIds - Completed " + DateUtil.getMMDDYYHHMM());
        }
        return artIds;
    }

    private static class TestTaskParent
    implements IAtsHealthCheck {
        private TestTaskParent() {
        }

        public void check(ArtifactId artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi) {
            if (workItem.isTask() && atsApi.getRelationResolver().getRelatedOrSentinel((IAtsObject)workItem, AtsRelationTypes.TeamWfToTask_TeamWf).isInvalid()) {
                this.error(results, workItem, "Task has no parent", new Object[0]);
            }
        }
    }

    private static class TestWorkflowDefinition
    implements IAtsHealthCheck {
        private TestWorkflowDefinition() {
        }

        public void check(ArtifactId artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi) {
            if (workItem.getWorkDefinition() == null) {
                this.error(results, workItem, "Workflow has no Work Definition", new Object[0]);
            } else if (workItem.getStateDefinition() == null) {
                this.error(results, workItem, "Workflow can not get State Definition", new Object[0]);
            } else if (workItem.getStateMgr().getCurrentState() == null) {
                this.error(results, workItem, "Workflow can not get current state", new Object[0]);
            }
        }
    }

    private static class TestWorkflowTeamDefinition
    implements IAtsHealthCheck {
        private TestWorkflowTeamDefinition() {
        }

        public void check(ArtifactId artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi) {
            if (workItem.isTeamWorkflow() && workItem.getParentTeamWorkflow().getTeamDefinition() == null) {
                this.error(results, workItem, "Team workflow has no Team Definition (re-run conversion?)", new Object[0]);
            }
        }
    }

    private static class TestWorkflowVersions
    implements IAtsHealthCheck {
        private final HashCollectionSet<IAtsTeamDefinition, IAtsVersion> teamDefToVersions = new HashCollectionSet(HashSet::new);

        private TestWorkflowVersions() {
        }

        private Collection<IAtsVersion> getTeamVersions(IAtsTeamDefinition teamDef) {
            IAtsTeamDefinition teamDefHoldingVers;
            Set teamDefVersions = (Set)this.teamDefToVersions.getValues((Object)teamDef);
            if (teamDefVersions == null && (teamDefHoldingVers = teamDef.getTeamDefinitionHoldingVersions()) != null) {
                teamDefVersions = teamDefHoldingVers.getTeamDefinitionHoldingVersions().getVersions();
                this.teamDefToVersions.put((Object)teamDef, (Collection)teamDefVersions);
            }
            return teamDefVersions;
        }

        public void check(ArtifactId artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi) {
            if (workItem.isTeamWorkflow()) {
                IAtsVersion version;
                IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)workItem;
                Collection versions = atsApi.getRelationResolver().getRelated((IAtsObject)teamWf, AtsRelationTypes.TeamWorkflowTargetedForVersion_Version);
                if (versions.size() > 1) {
                    this.error(results, workItem, "Team workflow has " + versions.size() + " versions; should only be 0 or 1", new Object[0]);
                } else if (versions.size() == 1 && (version = (IAtsVersion)atsApi.getQueryService().getConfigItem((ArtifactId)versions.iterator().next())) != null && !this.getTeamVersions(teamWf.getTeamDefinition()).contains(version)) {
                    this.error(results, workItem, "Team workflow " + teamWf.getAtsId() + " has version" + version.toStringWithId() + " that does not belong to teamDefHoldingVersions ", new Object[0]);
                }
            }
        }
    }
}

