/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.EnumEntry;

public class AttributeTypeToXWidgetName {
    public static String getXWidgetName(OrcsApi orcsApi, AttributeTypeId attributeType) {
        int minOccurrence = orcsApi.getOrcsTypes().getAttributeTypes().getMinOccurrences(attributeType);
        int maxOccurrence = orcsApi.getOrcsTypes().getAttributeTypes().getMaxOccurrences(attributeType);
        String xWidgetName = "";
        String baseType = orcsApi.getOrcsTypes().getAttributeTypes().getBaseAttributeTypeId(attributeType);
        if (baseType != null) {
            baseType = baseType.toLowerCase();
            xWidgetName = attributeType.equals(CoreAttributeTypes.AccessContextId) ? "XTextFlatDam" : (baseType.contains("enum") ? (maxOccurrence == 1 ? "XComboDam(" + Collections.toString((String)",", AttributeTypeToXWidgetName.getEnumerationValues(orcsApi, attributeType)) + ")" : "XSelectFromMultiChoiceDam(" + Collections.toString((String)",", AttributeTypeToXWidgetName.getEnumerationValues(orcsApi, attributeType)) + ")") : (baseType.contains("boolean") ? (minOccurrence == 1 ? "XCheckBoxDam" : "XComboBooleanDam") : (baseType.contains("date") ? "XDateDam" : (baseType.contains("integer") ? "XIntegerDam" : (baseType.contains("floating") ? "XFloatDam" : (baseType.contains("binary") ? "XLabelDam" : (baseType.contains("branchreference") ? "XBranchSelectWidget" : (baseType.contains("artifactreference") ? "XListDropViewWithSave" : (attributeType.equals(CoreAttributeTypes.IdValue) ? "XTextFlatDam" : (baseType.contains("string") ? (maxOccurrence == 1 ? "XTextDam" : "XStackedDam") : "XStackedDam"))))))))));
        }
        return xWidgetName;
    }

    private static Collection<String> getEnumerationValues(OrcsApi orcsApi, AttributeTypeId attributeType) {
        ArrayList<String> values = new ArrayList<String>();
        EnumEntry[] enumEntryArray = orcsApi.getOrcsTypes().getAttributeTypes().getEnumType(attributeType).values();
        int n = enumEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnumEntry entry = enumEntryArray[n2];
            values.add(entry.getName());
            ++n2;
        }
        return values;
    }
}

