/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.notify.IAtsNotifier;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IAtsStoreService;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogFactory;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateFactory;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.core.workflow.WorkItem;
import org.eclipse.osee.ats.rest.internal.util.AtsChangeSet;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class AtsStoreServiceImpl
implements IAtsStoreService {
    private final IAttributeResolver attributeResolver;
    private final OrcsApi orcsApi;
    private final IAtsStateFactory stateFactory;
    private final IAtsLogFactory logFactory;
    private final IAtsNotifier notifier;
    private final AtsApi atsApi;
    private final JdbcService jdbcService;

    public AtsStoreServiceImpl(IAttributeResolver attributeResolver, AtsApi atsApi, OrcsApi orcsApi, IAtsStateFactory stateFactory, IAtsLogFactory logFactory, IAtsNotifier notifier, JdbcService jdbcService) {
        this.atsApi = atsApi;
        this.attributeResolver = attributeResolver;
        this.orcsApi = orcsApi;
        this.logFactory = logFactory;
        this.stateFactory = stateFactory;
        this.notifier = notifier;
        this.jdbcService = jdbcService;
    }

    public JdbcService getJdbcService() {
        return this.jdbcService;
    }

    public IAtsChangeSet createAtsChangeSet(String comment, IAtsUser asUser) {
        return new AtsChangeSet(this.atsApi, this.attributeResolver, this.orcsApi, this.stateFactory, this.logFactory, comment, asUser, this.notifier);
    }

    public QueryBuilder getQuery() {
        return this.orcsApi.getQueryFactory().fromBranch((BranchId)this.atsApi.getAtsBranch());
    }

    public List<IAtsWorkItem> reload(Collection<IAtsWorkItem> inWorkWorkflows) {
        ArrayList<IAtsWorkItem> workItems = new ArrayList<IAtsWorkItem>(inWorkWorkflows.size());
        List ids = AtsObjects.toArtifactIds(inWorkWorkflows);
        Iterator arts = this.getQuery().andIds((Collection)ids).getResults().iterator();
        while (arts.hasNext()) {
            workItems.add(this.atsApi.getWorkItemService().getWorkItem((ArtifactToken)arts.next()));
        }
        return workItems;
    }

    public boolean isDeleted(IAtsObject atsObject) {
        return ((ArtifactReadable)this.atsApi.getQueryService().getArtifact(atsObject)).isDeleted();
    }

    public Set<ArtifactTypeToken> getTeamWorkflowArtifactTypes() {
        HashSet<ArtifactTypeToken> artifactTypes = new HashSet<ArtifactTypeToken>();
        artifactTypes.addAll(this.orcsApi.getOrcsTypes().getArtifactTypes().getAllDescendantTypes((ArtifactTypeId)AtsArtifactTypes.TeamWorkflow));
        return artifactTypes;
    }

    public boolean isAttributeTypeValid(IAtsObject atsObject, AttributeTypeToken attributeType) {
        return this.isAttributeTypeValid((ArtifactId)atsObject.getStoreObject(), attributeType);
    }

    public boolean isAttributeTypeValid(ArtifactId artifact, AttributeTypeToken attributeType) {
        return ((ArtifactReadable)artifact).isAttributeTypeValid(attributeType);
    }

    public AttributeTypeToken getAttributeType(String attrTypeName) {
        return this.orcsApi.getOrcsTypes().getAttributeTypes().getByName(attrTypeName);
    }

    public ArtifactTypeToken getArtifactType(ArtifactId artifact) {
        if (artifact instanceof ArtifactReadable) {
            return ((ArtifactReadable)artifact).getArtifactType();
        }
        return this.getQuery().andId(artifact).asArtifactToken().getArtifactType();
    }

    public boolean isDateType(AttributeTypeId attributeType) {
        return this.orcsApi.getOrcsTypes().getAttributeTypes().isDateType(attributeType);
    }

    public boolean isOfType(ArtifactId artifact, ArtifactTypeId ... artifactType) {
        return ((ArtifactReadable)this.atsApi.getQueryService().getArtifact(artifact)).isOfType(artifactType);
    }

    public boolean isOfType(IAtsObject atsObject, ArtifactTypeToken ... artifactType) {
        return ((ArtifactReadable)this.atsApi.getQueryService().getArtifact(atsObject)).isOfType((ArtifactTypeId[])artifactType);
    }

    public void executeChangeSet(String comment, IAtsObject atsObject) {
        this.executeChangeSet(comment, Collections.singleton(atsObject));
    }

    public void executeChangeSet(String comment, Collection<? extends IAtsObject> atsObjects) {
        IAtsChangeSet changes = this.createAtsChangeSet(comment, this.atsApi.getUserService().getCurrentUser());
        for (IAtsObject iAtsObject : atsObjects) {
            changes.add((Object)iAtsObject);
        }
        changes.execute();
    }

    public ArtifactTypeToken getArtifactType(Long artTypeId) {
        return (ArtifactTypeToken)this.orcsApi.getOrcsTypes().getArtifactTypes().get(artTypeId);
    }

    public Collection<AttributeTypeToken> getAttributeTypes() {
        return this.orcsApi.getOrcsTypes().getAttributeTypes().getAll();
    }

    public boolean isChangedInDb(IAtsWorkItem workItem) {
        return false;
    }

    public ArtifactTypeToken getArtifactType(IAtsObject atsObject) {
        return this.getArtifactType((ArtifactId)this.atsApi.getQueryService().getArtifact((ArtifactId)atsObject.getStoreObject()));
    }

    public boolean isOfType(IAtsObject atsObject, ArtifactTypeToken artifactType) {
        return this.isOfType((ArtifactId)atsObject.getStoreObject(), new ArtifactTypeId[]{artifactType});
    }

    public void clearCaches(IAtsWorkItem workItem) {
        ((WorkItem)workItem).clearCaches();
    }

    public boolean isArtifactTypeInheritsFrom(ArtifactTypeToken artifactType, ArtifactTypeToken baseArtifactType) {
        return this.orcsApi.getOrcsTypes().getArtifactTypes().inheritsFrom((ArtifactTypeId)artifactType, new ArtifactTypeId[]{baseArtifactType});
    }

    public AttributeTypeToken getAttributeType(Long attrTypeId) {
        return (AttributeTypeToken)this.orcsApi.getOrcsTypes().getAttributeTypes().get(attrTypeId);
    }

    public Result setTransactionAssociatedArtifact(TransactionId trans, IAtsTeamWorkflow teamWf) {
        this.orcsApi.getTransactionFactory().setTransactionCommitArtifact(trans, teamWf.getStoreObject());
        return Result.TrueResult;
    }

    public TransactionId getTransactionId(IAtsWorkItem workItem) {
        TransactionId transId = TransactionId.SENTINEL;
        ArtifactToken artifact = this.atsApi.getQueryService().getArtifact(workItem.getId());
        if (artifact instanceof ArtifactReadable) {
            transId = ((ArtifactReadable)artifact).getTransaction();
        }
        return transId;
    }

    public boolean isDeleted(ArtifactId artifact) {
        return ((ArtifactReadable)this.atsApi.getQueryService().getArtifact(artifact)).isDeleted();
    }

    public CustomizeData getCustomizationByGuid(String customize_guid) {
        CustomizeData cust = null;
        ArtifactReadable customizeStoreArt = (ArtifactReadable)this.getQuery().and((AttributeTypeId)CoreAttributeTypes.XViewerCustomization, customize_guid, QueryOption.CONTAINS_MATCH_OPTIONS).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (customizeStoreArt.isValid()) {
            for (String custXml : this.atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)customizeStoreArt, (AttributeTypeToken)CoreAttributeTypes.XViewerCustomization)) {
                if (!custXml.contains(customize_guid)) continue;
                cust = new CustomizeData(custXml);
                break;
            }
        }
        return cust;
    }

    public boolean isProductionDb() {
        return this.jdbcService.getClient().getConfig().isProduction();
    }

    public boolean isHistorical(IAtsObject atsObject) {
        return ((ArtifactReadable)this.atsApi.getQueryService().getArtifact(atsObject)).isHistorical();
    }

    public boolean isHistorical(ArtifactId artifact) {
        return ((ArtifactReadable)this.atsApi.getQueryService().getArtifact(artifact)).isHistorical();
    }

    public boolean inheritsFrom(ArtifactTypeToken artType, ArtifactTypeToken ... artifactType) {
        return this.orcsApi.getOrcsTypes().getArtifactTypes().inheritsFrom((ArtifactTypeId)artType, (ArtifactTypeId[])artifactType);
    }

    public boolean isReadOnly(IAtsWorkItem workItem) {
        throw new UnsupportedOperationException("unsupported on server");
    }

    public boolean isAccessControlWrite(IAtsWorkItem workItem) {
        throw new UnsupportedOperationException();
    }
}

