/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAtsWidgetDefinition;
import org.eclipse.osee.ats.core.workflow.AbstractAtsAttributeResolverService;
import org.eclipse.osee.ats.rest.internal.util.AttributeTypeToXWidgetName;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;

public class AtsAttributeResolverServiceImpl
extends AbstractAtsAttributeResolverService {
    private OrcsApi orcsApi;
    private Log logger;
    private AtsApi atsApi;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    private ArtifactReadable getArtifact(IAtsObject atsObject) {
        return (ArtifactReadable)this.atsApi.getQueryService().getArtifact(atsObject);
    }

    private ArtifactReadable getArtifact(ArtifactId artifact) {
        return (ArtifactReadable)this.atsApi.getQueryService().getArtifact(artifact);
    }

    public void start() {
        Conditions.checkNotNull((Object)this.orcsApi, (String)"OrcsApi");
        this.logger.info("AtsAttributeResolverServiceImpl started", new Object[0]);
    }

    public void stop() {
    }

    public boolean isAttributeNamed(String attributeName) {
        return this.getAttributeType(attributeName) != null;
    }

    public String getUnqualifiedName(String attributeName) {
        return this.getAttributeType(attributeName).getUnqualifiedName();
    }

    public void setXWidgetNameBasedOnAttributeName(String attributeName, IAtsWidgetDefinition widgetDef) {
        try {
            if (!Strings.isValid((String)widgetDef.getXWidgetName())) {
                widgetDef.setXWidgetName(AttributeTypeToXWidgetName.getXWidgetName(this.orcsApi, (AttributeTypeId)this.getAttributeType(attributeName)));
            }
        }
        catch (OseeCoreException ex) {
            this.logger.error((Throwable)ex, "Error setXWidgetNameBasedOnAttributeName - attributeName [%s] widgetDef[%s]", new Object[]{attributeName, widgetDef});
        }
    }

    public String getDescription(String attributeName) {
        return this.getAttributeType(attributeName).getDescription();
    }

    public AttributeTypeToken getAttributeType(String attributeName) {
        return this.orcsApi.getOrcsTypes().getAttributeTypes().getByName(attributeName);
    }

    public <T> T getSoleAttributeValue(IAtsObject atsObject, AttributeTypeToken attributeType, T defaultReturnValue) {
        return (T)this.getArtifact(atsObject).getSoleAttributeValue(attributeType, defaultReturnValue);
    }

    public List<String> getAttributesToStringList(IAtsObject atsObject, AttributeTypeToken attributeType) {
        return this.getArtifact(atsObject).getAttributeValues(attributeType);
    }

    public boolean isAttributeTypeValid(IAtsWorkItem workItem, AttributeTypeToken attributeType) {
        return this.getArtifact((IAtsObject)workItem).isAttributeTypeValid(attributeType);
    }

    public String getSoleAttributeValueAsString(IAtsObject atsObject, AttributeTypeToken attributeType, String defaultValue) {
        return this.getArtifact(atsObject).getAttributeValuesAsString(attributeType);
    }

    public String getSoleAttributeValueAsString(ArtifactId artifact, AttributeTypeToken attributeType, String defaultValue) {
        return (String)this.getArtifact(artifact).getSoleAttributeValue(attributeType, (Object)defaultValue);
    }

    public void setSoleAttributeValue(IAtsObject atsObject, AttributeTypeId attributeType, Object value) {
        throw new OseeStateException("Invalid: Must use setSoleAttributeValue(IAtsWorkItem workItem, AttributeTypeId attributeType, Object value, IAtsChangeSet changes)", new Object[0]);
    }

    public int getAttributeCount(IAtsWorkItem workItem, AttributeTypeToken attributeType) {
        return this.getArtifact((IAtsObject)workItem).getAttributeCount(attributeType);
    }

    public int getAttributeCount(IAtsObject atsObject, AttributeTypeToken attributeType) {
        return this.getArtifact(atsObject).getAttributeCount(attributeType);
    }

    public int getAttributeCount(ArtifactId artifact, AttributeTypeToken attributeType) {
        return this.getArtifact(artifact).getAttributeCount(attributeType);
    }

    public void addAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType, Object value) {
        throw new OseeStateException("Not Implemented", new Object[0]);
    }

    public <T> Collection<IAttribute<T>> getAttributes(IAtsObject atsObject, AttributeTypeToken attributeType) {
        ArrayList<IAttribute<T>> attrs = new ArrayList<IAttribute<T>>();
        for (AttributeReadable attr : this.getArtifact(atsObject).getAttributes((AttributeTypeId)attributeType)) {
            attrs.add((IAttribute<T>)attr);
        }
        return attrs;
    }

    public void deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType) {
        throw new OseeStateException("Invalid: Must use deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType, IAtsChangeSet changes)", new Object[0]);
    }

    public void deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType, IAtsChangeSet changes) {
        changes.deleteSoleAttribute(workItem, attributeType);
    }

    public void setSoleAttributeValue(IAtsObject atsObject, AttributeTypeToken attributeType, Object value, IAtsChangeSet changes) {
        changes.setSoleAttributeValue(atsObject, attributeType, value);
    }

    public void addAttribute(IAtsWorkItem workItem, AttributeTypeToken attributeType, Object value, IAtsChangeSet changes) {
        changes.addAttribute((IAtsObject)workItem, attributeType, value);
    }

    public void deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType, Object value, IAtsChangeSet changes) {
        changes.deleteAttribute((IAtsObject)workItem, attributeType, value);
    }

    public <T> void setValue(IAtsWorkItem workItem, IAttribute<T> attr, AttributeTypeId attributeType, T value, IAtsChangeSet changes) {
        changes.setValue(workItem, attr, attributeType, value);
    }

    public <T> void deleteAttribute(IAtsWorkItem workItem, IAttribute<T> attr, IAtsChangeSet changes) {
        changes.deleteAttribute(workItem, attr);
    }

    public <T> void deleteAttribute(IAtsWorkItem workItem, IAttribute<T> attr) {
        throw new OseeStateException("Invalid: Must use deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType, IAtsChangeSet changes)", new Object[0]);
    }

    public <T> void setValue(IAtsWorkItem workItem, IAttribute<String> attr, AttributeTypeId attributeType, T value) {
        throw new OseeStateException("Invalid: Must use deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType, IAtsChangeSet changes)", new Object[0]);
    }

    public <T> T getSoleAttributeValue(ArtifactId artifact, AttributeTypeToken attributeType, T defaultValue) {
        return (T)this.getArtifact(artifact).getSoleAttributeValue(attributeType, defaultValue);
    }

    public <T> Collection<T> getAttributeValues(ArtifactId artifact, AttributeTypeToken attributeType) {
        return this.getArtifact(artifact).getAttributeValues(attributeType);
    }

    public <T> Collection<T> getAttributeValues(IAtsObject atsObject, AttributeTypeToken attributeType) {
        return this.getAttributeValues((ArtifactId)atsObject.getStoreObject(), attributeType);
    }

    public <T> Collection<IAttribute<T>> getAttributes(ArtifactId artifact, AttributeTypeToken attributeType) {
        Assert.isNotNull((Object)artifact, (String)"Artifact can not be null");
        Assert.isNotNull((Object)attributeType, (String)"Attribute Type can not be null");
        LinkedList<IAttribute<T>> attributes = new LinkedList<IAttribute<T>>();
        for (AttributeReadable attr : ((ArtifactReadable)artifact).getAttributes((AttributeTypeId)attributeType)) {
            attributes.add((IAttribute<T>)attr);
        }
        return attributes;
    }

    public List<String> getAttributesToStringList(ArtifactId artifact, AttributeTypeToken attributeType) {
        return ((ArtifactReadable)artifact).getAttributeValues(attributeType);
    }

    public <T> Collection<IAttribute<T>> getAttributes(ArtifactId artifact) {
        LinkedList<IAttribute<T>> attributes = new LinkedList<IAttribute<T>>();
        for (AttributeReadable attr : this.getArtifact(artifact).getAttributes()) {
            attributes.add((IAttribute<T>)attr);
        }
        return attributes;
    }

    public <T> Collection<IAttribute<T>> getAttributes(IAtsWorkItem workItem) {
        return this.getAttributes((ArtifactId)workItem.getStoreObject());
    }

    public void setServices(AtsApi atsApi) {
        this.atsApi = atsApi;
    }
}

