/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.task;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.commit.ICommitConfigItem;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.config.tx.AtsTeamDefinitionArtifactToken;
import org.eclipse.osee.ats.api.config.tx.IAtsTeamDefinitionArtifactToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsTaskDefToken;
import org.eclipse.osee.ats.api.task.CreateTasksOption;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.create.ChangeReportOptions;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskData;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskMatch;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskMatchType;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskTeamWfData;
import org.eclipse.osee.ats.api.task.create.CreateTasksDefinition;
import org.eclipse.osee.ats.api.task.create.CreateTasksDefinitionBuilder;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.task.ChangeReportTasksUtil;
import org.eclipse.osee.ats.core.task.CreateTasksWorkflow;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class CreateChangeReportTasksOperation {
    private final AtsTaskDefToken taskDefToken;
    private final AtsApi atsApi;
    private final ChangeReportTaskData crtd;

    public CreateChangeReportTasksOperation(ChangeReportTaskData crtd, AtsApi atsApi) {
        this.crtd = crtd;
        this.taskDefToken = crtd.getTaskDefToken();
        this.atsApi = atsApi;
    }

    public ChangeReportTaskData run() {
        XResultData rd = this.crtd.getResults();
        try {
            if (this.crtd.getHostTeamWf() == null || this.crtd.getHostTeamWf().isInvalid()) {
                rd.error("No Host Team Workflow specified.\n");
                return this.crtd;
            }
            IAtsTeamWorkflow hostTeamWf = this.atsApi.getQueryService().getTeamWf((ArtifactId)this.crtd.getHostTeamWf());
            if (hostTeamWf == null) {
                rd.error("No Host Team Workflow can be found.\n");
                return this.crtd;
            }
            this.crtd.getIdToTeamWf().put(hostTeamWf.getId(), hostTeamWf);
            rd.logf("Creating from host Team Wf %s\n", new Object[]{hostTeamWf.toStringWithId()});
            CreateTasksDefinitionBuilder taskSetDefinition = this.atsApi.getTaskSetDefinitionProviderService().getTaskSetDefinition(this.taskDefToken);
            if (taskSetDefinition == null) {
                rd.errorf("No CreateTasksDefintiion found for Task Def id %s\n", new Object[]{this.taskDefToken.toStringWithId()});
                return this.crtd;
            }
            CreateTasksDefinition setDef = taskSetDefinition.getCreateTasksDef();
            rd.logf("Creating tasks for task definition %s\n", new Object[]{setDef.toStringWithId()});
            this.crtd.setSetDef(setDef);
            IAtsTeamWorkflow chgRptTeamWf = null;
            if (this.crtd.getChgRptTeamWf().isValid()) {
                chgRptTeamWf = this.atsApi.getQueryService().getTeamWf((ArtifactId)this.crtd.getHostTeamWf());
            } else {
                ChangeReportOptions opts = setDef.getChgRptOptions();
                IAtsTeamDefinitionArtifactToken fromSiblingTeam = AtsTeamDefinitionArtifactToken.valueOf((ArtifactToken)opts.getFromSiblingTeamDef());
                Collection siblings = this.atsApi.getWorkItemService().getSiblings(hostTeamWf, fromSiblingTeam);
                if (siblings.size() > 1 || siblings.isEmpty()) {
                    rd.errorf("Expeceted one source sibling workflow, found %s\n", new Object[]{siblings});
                    return this.crtd;
                }
                chgRptTeamWf = (IAtsTeamWorkflow)siblings.iterator().next();
            }
            rd.logf("Using Change Report Team Wf %s\n", new Object[]{chgRptTeamWf.toStringWithId()});
            this.crtd.getIdToTeamWf().put(chgRptTeamWf.getId(), chgRptTeamWf);
            this.crtd.setChgRptTeamWf(chgRptTeamWf.getStoreObject());
            ChangeReportTasksUtil.getBranchOrCommitChangeData((ChangeReportTaskData)this.crtd, (CreateTasksDefinition)setDef);
            if (this.crtd.getResults().isErrors()) {
                return this.crtd;
            }
            Map toSiblingTeamAis = setDef.getChgRptOptions().getToSiblingTeamAiMap();
            if (toSiblingTeamAis.isEmpty()) {
                rd.errorf("No sibling team defs found for id %s\n", new Object[]{this.taskDefToken.toStringWithId()});
                return this.crtd;
            }
            rd.logf("For Sibling Team AIs [%s]\n", new Object[]{Collections.toString((String)", ", toSiblingTeamAis.values())});
            ChangeReportTasksUtil.processChangeData((ChangeReportTaskData)this.crtd);
            if (this.crtd.getAllArtifacts().isEmpty()) {
                rd.log("No matching artifacts to create tasks\n");
                return this.crtd;
            }
            boolean fail = false;
            for (ArtifactId art : this.crtd.getAllArtifacts()) {
                try {
                    ArtifactReadable artifact = (ArtifactReadable)this.atsApi.getQueryService().getArtifact(art, this.crtd.getWorkOrParentBranch(), DeletionFlag.INCLUDE_DELETED);
                    artifact.getSafeName();
                }
                catch (Exception ex) {
                    rd.errorf("Exception accessing name of %s - %s\n", new Object[]{art.getId(), ex.getLocalizedMessage()});
                    fail = true;
                }
            }
            if (fail) {
                return this.crtd;
            }
            boolean reportOnly = this.getTaskDefinition().getChgRptOptions().getCreateOptions().contains(CreateTasksOption.ReportOnly);
            this.crtd.setReportOnly(reportOnly);
            rd.logf("Report Only %s\n", new Object[]{reportOnly});
            IAtsChangeSet changes = null;
            if (!reportOnly) {
                changes = this.atsApi.createChangeSet(setDef.getName());
            }
            for (Map.Entry teamDefAi : toSiblingTeamAis.entrySet()) {
                IAtsTeamDefinition teamDef = this.atsApi.getTeamDefinitionService().getTeamDefinitionById(ArtifactId.valueOf((String)((String)teamDefAi.getKey())));
                rd.logf("\n\nHandling Team %s\n", new Object[]{teamDef.toStringWithId()});
                ChangeReportTaskTeamWfData crttwd = new ChangeReportTaskTeamWfData();
                this.crtd.addChangeReportData(crttwd);
                crttwd.setReportOnly(reportOnly);
                crttwd.setRd(rd);
                crttwd.setChgRptTeamWf(chgRptTeamWf.getStoreObject());
                crttwd.getAddedModifiedArts().addAll(this.crtd.getAddedModifiedArts());
                crttwd.getDeletedArts().addAll(this.crtd.getDeletedArts());
                crttwd.getRelArts().addAll(this.crtd.getRelArts());
                crttwd.setDestTeamDef(teamDef.getStoreObject());
                WorkType workType = WorkType.None;
                String workTypeStr = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)teamDef, (AttributeTypeToken)AtsAttributeTypes.WorkType, (Object)"");
                if (Strings.isValid((String)workTypeStr)) {
                    workType = WorkType.valueOfOrNone((String)workTypeStr);
                }
                if (workType != WorkType.None) {
                    if (teamDef.getName().contains("Code")) {
                        workType = WorkType.Code;
                    } else if (teamDef.getName().contains("Test")) {
                        workType = WorkType.Test;
                    }
                }
                if (workType == WorkType.None) {
                    rd.errorf("\n\nCan't determine Work Type from Team Def or Name%s\n", new Object[]{teamDef.toStringWithId()});
                    return this.crtd;
                }
                crttwd.setWorkType(workType);
                IAtsVersion targetedVersion = this.atsApi.getVersionService().getTargetedVersion((IAtsWorkItem)chgRptTeamWf);
                IAtsActionableItem ai = this.atsApi.getActionableItemService().getActionableItem((String)teamDefAi.getValue());
                if (ai == null || ai.isInvalid()) {
                    rd.errorf("Actionable Item  %s is invalid for team %s\n", new Object[]{teamDefAi.getValue(), teamDefAi.getKey()});
                    return this.crtd;
                }
                ChangeReportTasksUtil.getTasksComputedAsNeeded((ChangeReportTaskData)this.crtd, (ChangeReportTaskTeamWfData)crttwd, (AtsApi)this.atsApi);
                for (ChangeReportTaskMatch taskMatch : crttwd.getTaskMatches()) {
                    if (!this.crtd.isDebug()) continue;
                    this.crtd.getResults().logf("Task Computed as Needed [%s]\n", new Object[]{taskMatch.toString()});
                }
                IAtsTeamWorkflow destTeamWf = ChangeReportTasksUtil.getDestTeamWfOrNull((ChangeReportTaskTeamWfData)crttwd, (WorkType)workType, (AtsApi)this.atsApi, (IAtsTeamWorkflow)chgRptTeamWf, (IAtsTeamDefinition)teamDef);
                if (destTeamWf == null) {
                    CreateTasksWorkflow workflowCreator = new CreateTasksWorkflow(hostTeamWf.getName(), setDef.getChgRptOptions().getCreateOptions(), true, reportOnly, crttwd.getRd(), changes, new Date(), AtsCoreUsers.SYSTEM_USER, chgRptTeamWf, (ICommitConfigItem)targetedVersion, crttwd.getWorkType(), null, null);
                    workflowCreator.setActionableItem(ai);
                    destTeamWf = workflowCreator.createMissingWorkflow();
                    rd.logf("Created Destination Team Wf %s\n", new Object[]{destTeamWf.toStringWithId()});
                } else {
                    rd.logf("Using existing Destination Team Wf %s\n", new Object[]{destTeamWf.toStringWithId()});
                }
                crttwd.setDestTeamWf(destTeamWf.getStoreObject());
                this.crtd.getIdToTeamWf().put(destTeamWf.getId(), destTeamWf);
                ChangeReportTasksUtil.determinExistingTaskMatchType((ChangeReportTaskTeamWfData)crttwd, (CreateTasksDefinition)setDef, (WorkType)workType, (IAtsTeamWorkflow)destTeamWf);
                HashSet<String> addModTaskNames = new HashSet<String>();
                HashSet<String> deletedTaskNames = new HashSet<String>();
                Date createdDate = new Date();
                for (ChangeReportTaskMatch taskMatch : crttwd.getTaskMatches()) {
                    ChangeReportTaskMatchType matchType = taskMatch.getMatchType();
                    if (matchType == ChangeReportTaskMatchType.Match) {
                        this.crtd.getResults().logf("Task %s Exists - No Change Needed\n", new Object[]{taskMatch.getTaskWf().toStringWithId()});
                        continue;
                    }
                    if (matchType == ChangeReportTaskMatchType.TaskComputedAsNeeded) {
                        if (addModTaskNames.contains(taskMatch.getTaskName())) continue;
                        this.crtd.getResults().warningf("Create new task [%s]\n", new Object[]{taskMatch.getTaskName()});
                        this.addToNewTaskData(crttwd, taskMatch, createdDate);
                        addModTaskNames.add(taskMatch.getTaskName());
                        continue;
                    }
                    if (matchType == ChangeReportTaskMatchType.TaskRefAttrMissing || matchType == ChangeReportTaskMatchType.TaskRefAttrValidButRefChgArtMissing) {
                        if (deletedTaskNames.contains(taskMatch.getTaskName())) continue;
                        this.crtd.getResults().warningf("Delete un-referenced task [%s]\n", new Object[]{taskMatch.getTaskName()});
                        if (!reportOnly) {
                            if (changes == null) {
                                this.crtd.getResults().errorf("AtsChangeSet can not be null.", new Object[0]);
                            } else {
                                changes.deleteArtifact((IAtsWorkItem)taskMatch.getTaskWf());
                            }
                        }
                        deletedTaskNames.add(taskMatch.getTaskName());
                        continue;
                    }
                    this.crtd.getResults().errorf("Unhandled Match Type [%s]\n", new Object[]{taskMatch.getMatchType().name()});
                }
                if (reportOnly) {
                    return this.crtd;
                }
                crttwd.getNewTaskData().setAsUserId(this.crtd.getAsUser().getUserId());
                crttwd.getNewTaskData().setCommitComment("Create Change Report Tasks");
                crttwd.getNewTaskData().setTeamWfId(destTeamWf.getId());
                this.atsApi.getTaskService().createTasks(crttwd.getNewTaskData(), changes, rd, this.crtd.getIdToTeamWf());
            }
            if (!reportOnly && changes != null) {
                TransactionId transId = changes.executeIfNeeded();
                if (transId.isValid()) {
                    this.crtd.getResults().log("Tasks Updated\n");
                } else {
                    this.crtd.getResults().log("No Changes Needed\n");
                }
            }
        }
        catch (Exception ex) {
            this.crtd.results.errorf("Exception creating tasks %s", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return this.crtd;
    }

    private void addToNewTaskData(ChangeReportTaskTeamWfData crttwd, ChangeReportTaskMatch taskMatch, Date createdDate) {
        JaxAtsTask task = new JaxAtsTask();
        task.setName(taskMatch.getTaskName());
        task.setCreatedDate(createdDate);
        task.setCreatedByUserId(AtsCoreUsers.SYSTEM_USER.getUserId());
        task.setAssigneeUserIds(Arrays.asList(AtsCoreUsers.UNASSIGNED_USER.getUserId()));
        task.addAttribute((AttributeTypeToken)AtsAttributeTypes.TaskToChangedArtifactReference, (Object)taskMatch.getChgRptArt());
        crttwd.getNewTaskData().getNewTasks().add(task);
    }

    private void dereferenceTask(ChangeReportTaskTeamWfData crd, IAtsTask task) {
        crd.getRd().logf("No matching artifact for Task %s; De-referenced task can be deleted.", new Object[]{task.toStringWithId()});
        crd.isPersist();
    }

    protected CreateTasksDefinition getTaskDefinition() {
        return this.atsApi.getTaskSetDefinitionProviderService().getTaskSetDefinition(this.taskDefToken).getCreateTasksDef();
    }

    protected Collection<AttributeTypeId> getAttributeTypesToIgnore() {
        return Collections.castAll((Collection)this.getTaskDefinition().getChgRptOptions().getNotAttributeTypes());
    }
}

