/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.config.AtsAttributeValueColumn;
import org.eclipse.osee.ats.api.config.AtsViews;
import org.eclipse.osee.ats.api.config.IAtsConfigurationViewsProvider;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.ColorColumns;
import org.eclipse.osee.ats.core.column.ColorTeamColumn;
import org.eclipse.osee.ats.rest.internal.config.AtsConfigurationViewsService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class UpdateAtsConfiguration {
    private static final String VIEWS_KEY = "views";
    private static final String VIEWS_EQUAL_KEY = "views=";
    private static final String COLOR_COLUMN_KEY = "colorColumns";
    public static final String VALID_STATE_NAMES_KEY = "validStateNames";
    private final AtsApi atsApi;
    private final OrcsApi orcsApi;

    public UpdateAtsConfiguration(AtsApi atsApi, OrcsApi orcsApi) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    public XResultData createUpdateConfig(XResultData rd) {
        UserToken user = SystemUser.OseeSystem;
        ArtifactReadable atsConfigArt = (ArtifactReadable)this.getOrCreateAtsConfig((UserId)user, rd);
        this.createRuleDefinitions((UserId)user, rd);
        this.createUpdateColorColumnAttributes();
        this.createUpdateConfigAttributes(atsConfigArt, (UserId)user, rd);
        try {
            this.createUpdateValidStateAttributes();
        }
        catch (Exception ex) {
            rd.errorf("Error in createUpdateValidStateAttributes [%s]", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return rd;
    }

    private void createRuleDefinitions(UserId userId, XResultData rd) {
        try {
            if ((ArtifactReadable)this.atsApi.getQueryService().getArtifact((ArtifactId)AtsArtifactToken.RuleDefinitions) == null) {
                TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, userId, "Add Rule Definitions Artifact");
                ArtifactToken headingArt = this.atsApi.getQueryService().getArtifact((ArtifactId)AtsArtifactToken.HeadingFolder);
                ArtifactToken ruleDefConfigArt = tx.createArtifact(AtsArtifactToken.RuleDefinitions);
                String ruleDefs = OseeInf.getResourceContents((String)"atsConfig/ruleDefinitions.ats", this.getClass());
                tx.createAttribute((ArtifactId)ruleDefConfigArt, (AttributeTypeToken)AtsAttributeTypes.DslSheet, (Object)ruleDefs);
                if (rd.isErrors()) {
                    throw new OseeStateException(rd.toString(), new Object[0]);
                }
                tx.relate((ArtifactId)headingArt, (RelationTypeToken)CoreRelationTypes.Default_Hierarchical__Child, (ArtifactId)ruleDefConfigArt);
                tx.commit();
            }
        }
        catch (Exception ex) {
            OseeLog.log(UpdateAtsConfiguration.class, (Level)Level.SEVERE, (Throwable)ex);
            rd.error("Error loading column ruleDefinitions.ats file (see log for details) " + ex.getLocalizedMessage());
        }
    }

    private List<String> getViewsJsonStrings() throws Exception {
        LinkedList<String> viewsJson = new LinkedList<String>();
        viewsJson.add(OseeInf.getResourceContents((String)"atsConfig/views.json", this.getClass()));
        for (IAtsConfigurationViewsProvider provider : AtsConfigurationViewsService.getViewsProviders()) {
            viewsJson.add(provider.getViewsJson());
        }
        return viewsJson;
    }

    private void createUpdateConfigAttributes(ArtifactReadable configArt, UserId userId, XResultData rd) {
        try {
            AtsViews databaseViews = this.getConfigViews();
            for (String viewsJson : this.getViewsJsonStrings()) {
                AtsViews atsViews = (AtsViews)JsonUtil.readValue((String)viewsJson, AtsViews.class);
                LinkedList<AtsAttributeValueColumn> toAdd = new LinkedList<AtsAttributeValueColumn>();
                for (AtsAttributeValueColumn defaultView : atsViews.getAttrColumns()) {
                    boolean found = false;
                    for (AtsAttributeValueColumn dbView : databaseViews.getAttrColumns()) {
                        boolean defaultViewNameValid;
                        boolean bl = defaultViewNameValid = Strings.isValid((String)dbView.getName()) && Strings.isValid((String)defaultView.getName());
                        if (defaultViewNameValid && dbView.getName().equals(defaultView.getName())) {
                            found = true;
                            break;
                        }
                        if (found || !dbView.getAttrTypeName().equals(defaultView.getAttrTypeName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    toAdd.add(defaultView);
                }
                databaseViews.getAttrColumns().addAll(toAdd);
            }
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, userId, "Create Update Config Attributes");
            Iterator iterator = configArt.getAttributes((AttributeTypeToken)CoreAttributeTypes.GeneralStringData, DeletionFlag.EXCLUDE_DELETED).iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                AttributeReadable attributeReadable = (AttributeReadable)iterator.next();
                if (attributeReadable == null || !((String)attributeReadable.getValue()).startsWith(VIEWS_EQUAL_KEY)) continue;
                tx.setAttributeById((ArtifactId)configArt, (AttributeId)attributeReadable, this.getViewsAttrValue(databaseViews));
                rd.log("Create or update AtsConfig.VIEWS attribute\n");
                found = true;
                break;
            }
            if (!found) {
                tx.createAttribute((ArtifactId)configArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)this.getViewsAttrValue(databaseViews));
                rd.log("Creating VIEWS attribute\n");
            }
            tx.commit();
        }
        catch (Exception ex) {
            OseeLog.log(UpdateAtsConfiguration.class, (Level)Level.SEVERE, (Throwable)ex);
            rd.error("Error loading column views.json file (see log for details) " + ex.getLocalizedMessage());
        }
    }

    private String getViewsAttrValue(AtsViews defaultViews) {
        return VIEWS_EQUAL_KEY + JsonUtil.toJson((Object)defaultViews);
    }

    public ArtifactId getOrCreateAtsConfig(UserId userId, XResultData rd) {
        ArtifactToken atsConfigArt = this.atsApi.getQueryService().getArtifact((ArtifactId)AtsArtifactToken.AtsConfig);
        if (atsConfigArt == null) {
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, userId, "Create AtsConfig");
            ArtifactToken headingArt = this.atsApi.getQueryService().getArtifact((ArtifactId)AtsArtifactToken.HeadingFolder);
            atsConfigArt = tx.createArtifact(AtsArtifactToken.AtsConfig);
            tx.relate((ArtifactId)headingArt, (RelationTypeToken)CoreRelationTypes.Default_Hierarchical__Parent, (ArtifactId)atsConfigArt);
            tx.commit();
            rd.log("Created AtsConfig");
        }
        return atsConfigArt;
    }

    private void createUpdateColorColumnAttributes() {
        ColorColumns columns = new ColorColumns();
        columns.addColumn(ColorTeamColumn.getColor());
        String colorColumnsJson = JsonUtil.toJson((Object)columns);
        this.atsApi.setConfigValue(COLOR_COLUMN_KEY, colorColumnsJson);
    }

    private void createUpdateValidStateAttributes() throws Exception {
        Collection validStateNames = this.atsApi.getWorkDefinitionService().getAllValidStateNames(new XResultData());
        this.atsApi.setConfigValue(VALID_STATE_NAMES_KEY, Collections.toString((String)",", (Iterable)validStateNames));
    }

    public ArtifactId getOrCreateConfigsFolder(UserId userId, XResultData rd) {
        ArtifactToken configsFolderArt = this.atsApi.getQueryService().getArtifact((ArtifactId)AtsArtifactToken.ConfigsFolder);
        if (configsFolderArt == null) {
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, userId, "Create Configs Folder");
            configsFolderArt = tx.createArtifact(AtsArtifactToken.ConfigsFolder);
            ArtifactToken headingArt = this.atsApi.getQueryService().getArtifact((ArtifactId)AtsArtifactToken.HeadingFolder);
            tx.relate((ArtifactId)configsFolderArt, (RelationTypeToken)CoreRelationTypes.Default_Hierarchical__Parent, (ArtifactId)headingArt);
            tx.commit();
            rd.log("Created Configs Folder");
        }
        return configsFolderArt;
    }

    public Collection<String> getValidStateNames() {
        String stateNamesStr = this.atsApi.getConfigValue(VALID_STATE_NAMES_KEY);
        LinkedList<String> stateNames = new LinkedList<String>();
        if (Strings.isValid((String)stateNamesStr)) {
            String[] stringArray = stateNamesStr.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String stateName = stringArray[n2];
                stateNames.add(stateName);
                ++n2;
            }
        }
        return stateNames;
    }

    public AtsViews getConfigViews() {
        String viewsStr = this.atsApi.getConfigValue(VIEWS_KEY);
        AtsViews views = null;
        views = Strings.isValid((String)viewsStr) ? (AtsViews)JsonUtil.readValue((String)viewsStr, AtsViews.class) : new AtsViews();
        return views;
    }

    public ColorColumns getColorColumns() {
        String colorStr = this.atsApi.getConfigValue(COLOR_COLUMN_KEY);
        ColorColumns columns = null;
        columns = Strings.isValid((String)colorStr) ? (ColorColumns)JsonUtil.readValue((String)colorStr, ColorColumns.class) : new ColorColumns();
        return columns;
    }
}

