/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.core.util.ConvertAtsConfigGuidAttributesOperations;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class ConvertAtsConfigGuidAttributesOperation {
    private final AtsApi atsApi;
    boolean workPackagesLoaded = false;
    Map<String, IAtsWorkPackage> guidToWorkPackage = new HashMap<String, IAtsWorkPackage>();

    public ConvertAtsConfigGuidAttributesOperation(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public XResultData createUpdateConfig(XResultData rd) {
        IAtsChangeSet changes;
        this.atsApi.getLogger().error("starting", new Object[0]);
        LinkedList artIdList = new LinkedList();
        artIdList.addAll(this.atsApi.getQueryService().createQuery(WorkItemType.TeamWorkflow, new WorkItemType[0]).andNotExists((AttributeTypeId)AtsAttributeTypes.TeamDefinitionReference).getItemIds());
        artIdList.addAll(this.atsApi.getQueryService().createQuery(WorkItemType.TeamWorkflow, new WorkItemType[0]).andNotExists((AttributeTypeId)AtsAttributeTypes.TeamDefinition).getItemIds());
        List subDivide = Collections.subDivide(artIdList, (int)2000);
        int size = subDivide.size();
        int count = 1;
        for (Collection artIds : subDivide) {
            this.atsApi.getLogger().info(String.format("processing %s / %s", count++, size), new Object[0]);
            LinkedList<Long> ids = new LinkedList<Long>();
            for (ArtifactId art : artIds) {
                ids.add(art.getId());
            }
            Collection allArtifacts = this.atsApi.getQueryService().getArtifacts(ids);
            changes = this.atsApi.createChangeSet("Update TeamDef, AI and WorkPkg TeamWf GUIDs");
            for (ArtifactToken art : allArtifacts) {
                ConvertAtsConfigGuidAttributesOperations.convertTeamDefinitionIfNeeded((IAtsChangeSet)changes, (ArtifactToken)art, (AtsApi)this.atsApi);
                ConvertAtsConfigGuidAttributesOperations.convertActionableItemsIfNeeded((IAtsChangeSet)changes, (ArtifactToken)art, (AtsApi)this.atsApi);
                this.atsApi.getLogger().error("Work Item - " + art.toStringWithId(), new Object[0]);
            }
            TransactionId transaction = changes.executeIfNeeded();
            if (transaction != null && transaction.isValid()) {
                this.atsApi.getLogger().info("================================== > executed", new Object[0]);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        LinkedList<ArtifactId> artIdList2 = new LinkedList<ArtifactId>();
        artIdList2.addAll(this.getWorkItemIdsMissingWorkPacakge());
        List subDivide2 = Collections.subDivide(artIdList2, (int)2000);
        int size2 = subDivide2.size();
        int count2 = 1;
        for (Collection artIds : subDivide2) {
            this.atsApi.getLogger().info(String.format("processing %s / %s", count2++, size2), new Object[0]);
            LinkedList<Long> ids = new LinkedList<Long>();
            for (ArtifactId art : artIds) {
                ids.add(art.getId());
            }
            Collection allArtifacts = this.atsApi.getQueryService().getArtifacts(ids);
            IAtsChangeSet changes2 = this.atsApi.createChangeSet("Update Work Package GUIDs");
            for (ArtifactToken art : allArtifacts) {
                this.convertWorkPackageIfNeeded(changes2, art);
            }
            TransactionId transaction = changes2.executeIfNeeded();
            if (transaction != null && transaction.isValid()) {
                this.atsApi.getLogger().info("================================== > executed", new Object[0]);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        changes = this.atsApi.createChangeSet("Update Program Team Def GUID");
        for (IAtsProgram program : this.atsApi.getQueryService().createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.Program}).getItems(IAtsProgram.class)) {
            ConvertAtsConfigGuidAttributesOperations.convertTeamDefinitionIfNeeded((IAtsChangeSet)changes, (ArtifactToken)program.getStoreObject(), (AtsApi)this.atsApi);
        }
        changes.executeIfNeeded();
        changes = this.atsApi.createChangeSet("Remove Action AI and TeamDef GUIDs");
        for (ArtifactToken actionArt : this.atsApi.getQueryService().getArtifacts((BranchId)this.atsApi.getAtsBranch(), false, new ArtifactTypeToken[]{AtsArtifactTypes.Action})) {
            changes.deleteAttributes((ArtifactId)actionArt, (AttributeTypeToken)AtsAttributeTypes.TeamDefinition);
            changes.deleteAttributes((ArtifactId)actionArt, (AttributeTypeToken)AtsAttributeTypes.ActionableItem);
        }
        changes.executeIfNeeded();
        changes = this.atsApi.createChangeSet("Update AIs for ats.Review GUIDs");
        for (IAtsProgram program : this.atsApi.getQueryService().createQuery(WorkItemType.Review, new WorkItemType[0]).getItems(IAtsAbstractReview.class)) {
            ConvertAtsConfigGuidAttributesOperations.convertActionableItemsIfNeeded((IAtsChangeSet)changes, (ArtifactToken)program.getStoreObject(), (AtsApi)this.atsApi);
        }
        changes.executeIfNeeded();
        this.atsApi.getLogger().error("complete", new Object[0]);
        return rd;
    }

    private Set<ArtifactId> getWorkItemIdsMissingWorkPacakge() {
        List haveWorkPackageGuid = this.atsApi.getQueryService().getArtifactIdsFromQuery("SELECT UNIQUE attr.art_id FROM OSEE_ATTRIBUTE attr, OSEE_TXS txs WHERE attr.GAMMA_ID = txs.GAMMA_ID AND txs.BRANCH_ID = 570 AND txs.TX_CURRENT = 1 AND attr.ATTR_TYPE_ID = 1152921504606847876", new Object[0]);
        List haveWorkPackageId = this.atsApi.getQueryService().getArtifactIdsFromQuery("SELECT UNIQUE attr.art_id FROM OSEE_ATTRIBUTE attr, OSEE_TXS txs WHERE attr.GAMMA_ID = txs.GAMMA_ID AND txs.BRANCH_ID = 570 AND txs.TX_CURRENT = 1 AND attr.ATTR_TYPE_ID = 473096133909456789", new Object[0]);
        HashSet<ArtifactId> missingWorkPackage = new HashSet<ArtifactId>();
        missingWorkPackage.addAll(Collections.setComplement((Collection)haveWorkPackageGuid, (Collection)haveWorkPackageId));
        missingWorkPackage.addAll(Collections.setComplement((Collection)haveWorkPackageId, (Collection)haveWorkPackageGuid));
        return missingWorkPackage;
    }

    private void convertWorkPackageIfNeeded(IAtsChangeSet changes, ArtifactToken workItemArt) {
        String workPackageGuid;
        ArtifactId workPackageId;
        if (!this.workPackagesLoaded) {
            for (ArtifactToken workPackageArt : this.atsApi.getQueryService().getArtifacts((BranchId)this.atsApi.getAtsBranch(), false, new ArtifactTypeToken[]{AtsArtifactTypes.WorkPackage})) {
                IAtsWorkPackage workPkg = this.atsApi.getEarnedValueService().getWorkPackage((ArtifactId)workPackageArt);
                this.guidToWorkPackage.put(workPkg.getStoreObject().getGuid(), workPkg);
            }
            this.workPackagesLoaded = true;
        }
        if ((workPackageId = this.atsApi.getAttributeResolver().getSoleArtifactIdReference(workItemArt, (AttributeTypeToken)AtsAttributeTypes.WorkPackageReference, ArtifactId.SENTINEL)).isInvalid() && Strings.isValid((String)(workPackageGuid = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)workItemArt, (AttributeTypeToken)AtsAttributeTypes.WorkPackageGuid, (Object)"")))) {
            IAtsWorkPackage workPackage = this.guidToWorkPackage.get(workPackageGuid);
            if (workPackage == null) {
                this.atsApi.getLogger().error(String.format("Work Package null for guid %s; deleting attribute for %s", workPackageGuid, workItemArt.toStringWithId()), new Object[0]);
                changes.deleteAttributes((ArtifactId)workItemArt, (AttributeTypeToken)AtsAttributeTypes.WorkPackageGuid);
                return;
            }
            changes.setSoleAttributeValue((ArtifactId)workItemArt, (AttributeTypeToken)AtsAttributeTypes.WorkPackageReference, (Object)workPackage.getStoreObject());
        }
        if (Strings.isInValid((String)(workPackageGuid = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)workItemArt, (AttributeTypeToken)AtsAttributeTypes.WorkPackageGuid, (Object)"")))) {
            ArtifactId workPackageArt = this.atsApi.getAttributeResolver().getSoleArtifactIdReference(workItemArt, (AttributeTypeToken)AtsAttributeTypes.WorkPackageReference, ArtifactId.SENTINEL);
            ArtifactReadable artifact = (ArtifactReadable)this.atsApi.getQueryService().getArtifact(workPackageArt);
            if (artifact != null) {
                changes.setSoleAttributeValue((ArtifactId)workItemArt, (AttributeTypeToken)AtsAttributeTypes.WorkPackageGuid, (Object)artifact.getGuid());
            }
        }
    }
}

