/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.net.URI;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.config.BaseConfigEndpointApi;
import org.eclipse.osee.ats.api.config.JaxAtsObject;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public abstract class BaseConfigEndpointImpl<T extends JaxAtsObject>
implements BaseConfigEndpointApi<T> {
    protected final AtsApi atsApi;
    protected final ArtifactTypeToken artifactType;
    protected final ArtifactToken typeFolder;

    public BaseConfigEndpointImpl(ArtifactTypeToken artifactType, ArtifactToken typeFolder, AtsApi atsApi) {
        this.artifactType = artifactType;
        this.typeFolder = typeFolder;
        this.atsApi = atsApi;
    }

    @GET
    public List<T> get() throws Exception {
        return this.getObjects();
    }

    @GET
    @Path(value="{id}")
    public T get(@PathParam(value="id") long id) throws Exception {
        return this.getObject(id);
    }

    @POST
    public Response create(T jaxAtsObject) throws Exception {
        if (jaxAtsObject.getId() <= 0L) {
            throw new OseeStateException("Invalid id %d", new Object[0]);
        }
        if (!Strings.isValid((String)jaxAtsObject.getName())) {
            throw new OseeStateException("Invalid name [%d]", new Object[0]);
        }
        ArtifactReadable artifact = (ArtifactReadable)this.atsApi.getQueryService().getArtifact(jaxAtsObject.getId());
        if (artifact != null) {
            throw new OseeStateException("Artifact with id %d already exists", new Object[]{jaxAtsObject.getId()});
        }
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Create " + this.artifactType.getName(), AtsCoreUsers.SYSTEM_USER);
        ArtifactToken newArtifact = changes.createArtifact(this.artifactType, jaxAtsObject.getName(), jaxAtsObject.getId());
        if (this.typeFolder != null) {
            ArtifactReadable typeFolderArtifact = (ArtifactReadable)this.atsApi.getQueryService().getArtifact((ArtifactId)this.typeFolder);
            if (typeFolderArtifact == null) {
                typeFolderArtifact = (ArtifactReadable)changes.createArtifact(AtsArtifactToken.CountryFolder);
            }
            if (typeFolderArtifact.getParent() == null) {
                ArtifactReadable headingFolder = (ArtifactReadable)this.atsApi.getQueryService().getArtifact((ArtifactId)AtsArtifactToken.HeadingFolder);
                changes.relate((Object)headingFolder, CoreRelationTypes.Default_Hierarchical__Child, (Object)typeFolderArtifact);
            }
            changes.relate((Object)typeFolderArtifact, CoreRelationTypes.Default_Hierarchical__Child, (Object)newArtifact);
        }
        if (Strings.isValid((String)jaxAtsObject.getDescription())) {
            changes.setSoleAttributeValue((ArtifactId)newArtifact, (AttributeTypeToken)AtsAttributeTypes.Description, (Object)jaxAtsObject.getDescription());
        } else {
            changes.deleteAttributes((ArtifactId)newArtifact, (AttributeTypeToken)AtsAttributeTypes.Description);
        }
        changes.setSoleAttributeValue((ArtifactId)newArtifact, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)jaxAtsObject.isActive());
        this.create(jaxAtsObject, (ArtifactId)newArtifact, changes);
        changes.execute();
        return Response.created((URI)new URI("/" + jaxAtsObject.getId())).build();
    }

    protected void create(T jaxAtsObject, ArtifactId newArtifact, IAtsChangeSet changes) {
    }

    @DELETE
    public Response delete(@PathParam(value="id") long id) throws Exception {
        ArtifactReadable artifact = (ArtifactReadable)this.atsApi.getQueryService().getArtifact(Long.valueOf(id));
        if (artifact == null) {
            throw new OseeStateException("Artifact with id %d not found", new Object[]{id});
        }
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Create " + this.artifactType.getName(), AtsCoreUsers.SYSTEM_USER);
        changes.deleteArtifact((ArtifactId)artifact);
        changes.execute();
        return Response.ok().build();
    }

    public abstract T getConfigObject(ArtifactId var1);

    protected T getObject(long id) {
        ArtifactToken configArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(id));
        return this.getConfigObject((ArtifactId)configArt);
    }

    public abstract List<T> getObjects();
}

