/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.util.Arrays;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsUserGroups;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionTokens;
import org.eclipse.osee.ats.core.config.OrganizePrograms;
import org.eclipse.osee.ats.rest.internal.config.AtsConfigEndpointImpl;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.server.OseeInfo;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.OrcsApi;

public class AtsDatabaseConfig {
    private final AtsApi atsApi;
    private final OrcsApi orcsApi;

    public AtsDatabaseConfig(AtsApi atsApi, OrcsApi orcsApi) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    public XResultData run() {
        OseeInfo.setValue((JdbcClient)this.atsApi.getJdbcService().getClient(), (String)"osee.work.def.as.name", (String)"true");
        XResultData results = this.createAtsFolders();
        if (results.isErrors()) {
            return results;
        }
        IAtsTeamDefinition topTeam = this.atsApi.getTeamDefinitionService().getTeamDefinitionById((ArtifactId)AtsArtifactToken.TopTeamDefinition);
        IAtsActionableItem topAi = this.atsApi.getActionableItemService().getActionableItemById((ArtifactId)AtsArtifactToken.TopActionableItem);
        IAtsChangeSet changes = this.atsApi.createChangeSet("Set Top Team Work Definition");
        this.atsApi.getWorkDefinitionService().setWorkDefinitionAttrs(topTeam, (NamedIdBase)AtsWorkDefinitionTokens.WorkDef_Team_Default, changes);
        changes.setSoleAttributeValue((IAtsObject)topAi, (AttributeTypeToken)AtsAttributeTypes.Actionable, (Object)false);
        changes.execute();
        this.atsApi.clearCaches();
        AtsDatabaseConfig.createUserGroups(this.atsApi);
        this.createUserCreationDisabledConfig();
        return results;
    }

    public static void createUserGroups(AtsApi atsApi) {
        if (atsApi.getQueryService().getArtifact((ArtifactId)AtsUserGroups.AtsAdmin) == null) {
            IAtsChangeSet changes = atsApi.createChangeSet("Create Admin groups");
            ArtifactToken userGroup = atsApi.getQueryService().getArtifact((ArtifactId)CoreArtifactTokens.UserGroups);
            changes.createArtifact(userGroup, (ArtifactToken)AtsUserGroups.AtsAdmin);
            changes.createArtifact(userGroup, (ArtifactToken)AtsUserGroups.AtsTempAdmin);
            changes.execute();
        }
    }

    private void createUserCreationDisabledConfig() {
        this.atsApi.setConfigValue("UserCreationDisabled2", String.valueOf(AtsArtifactTypes.Action.toStringWithId()) + ";" + AtsArtifactTypes.TeamWorkflow.toStringWithId());
    }

    public XResultData createAtsFolders() {
        IAtsChangeSet changes = this.atsApi.createChangeSet("Create ATS Folders");
        ArtifactToken headingArt = this.atsApi.getQueryService().getOrCreateArtifact(CoreArtifactTokens.OseeConfiguration, AtsArtifactToken.HeadingFolder, changes);
        for (ArtifactToken token : Arrays.asList(AtsArtifactToken.TopActionableItem, AtsArtifactToken.TopTeamDefinition, AtsArtifactToken.WorkDefinitionsFolder)) {
            this.atsApi.getQueryService().getOrCreateArtifact(headingArt, token, changes);
        }
        changes.execute();
        AtsConfigEndpointImpl configEp = new AtsConfigEndpointImpl(this.atsApi, this.orcsApi, this.atsApi.getLogger(), null);
        XResultData results = configEp.createUpdateConfig();
        if (results.isErrors()) {
            return results;
        }
        new OrganizePrograms(this.atsApi).run();
        return results;
    }
}

