/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.config.AtsConfiguration;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.api.config.AtsViews;
import org.eclipse.osee.ats.api.config.JaxActionableItem;
import org.eclipse.osee.ats.api.config.JaxTeamDefinition;
import org.eclipse.osee.ats.api.config.JaxVersion;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.data.AtsUserGroups;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.core.config.AbstractAtsConfigurationService;
import org.eclipse.osee.ats.rest.internal.config.AtsDatabaseConfig;
import org.eclipse.osee.ats.rest.internal.config.UpdateAtsConfiguration;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class AtsConfigurationsService
extends AbstractAtsConfigurationService {
    private final OrcsApi orcsApi;

    public AtsConfigurationsService(AtsApi atsApi, OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.atsApi = atsApi;
    }

    public AtsConfigurations getConfigurations() {
        if (this.atsConfigurations == null) {
            this.load(false);
        }
        return this.atsConfigurations;
    }

    public AtsConfigurations getConfigurationsWithPend() {
        return this.load(true);
    }

    private synchronized AtsConfigurations load(boolean reload) {
        if (reload || this.atsConfigurations == null) {
            this.atsConfigurations = this.orcsApi.getAdminOps().isDataStoreInitialized() ? this.getAtsConfigurationsFromDb() : new AtsConfigurations();
        }
        return this.atsConfigurations;
    }

    private AtsConfigurations getAtsConfigurationsFromDb() {
        LinkedList<Long> teamDefIds = new LinkedList<Long>();
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON);
        for (ArtifactId art : query.andTypeEquals(new ArtifactTypeId[]{AtsArtifactTypes.TeamDefinition}).asArtifactIds()) {
            teamDefIds.add(art.getId());
        }
        LinkedList<Long> aiIds = new LinkedList<Long>();
        for (ArtifactId art : query.andTypeEquals(new ArtifactTypeId[]{AtsArtifactTypes.ActionableItem}).asArtifactIds()) {
            aiIds.add(art.getId());
        }
        List artifacts = Collections.castAll((Collection)this.atsApi.getQueryService().getArtifacts(AtsArtifactTypes.Configuration));
        AtsConfigurations configs = new AtsConfigurations();
        for (ArtifactReadable art : artifacts) {
            AtsConfiguration config = new AtsConfiguration();
            configs.getConfigs().add(config);
            config.setName(art.getName());
            config.setArtifactId((ArtifactId)art);
            config.setBranchId(BranchId.valueOf((String)((String)art.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.AtsConfiguredBranch, (Object)"0"))));
            config.setIsDefault(((Boolean)art.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.Default, (Object)false)).booleanValue());
        }
        UpdateAtsConfiguration update = new UpdateAtsConfiguration(this.atsApi, this.orcsApi);
        AtsViews views = update.getConfigViews();
        configs.setViews(views);
        configs.setColorColumns(update.getColorColumns());
        configs.setValidStateNames(update.getValidStateNames());
        for (IAtsUser user : this.atsApi.getUserService().getUsersFromDb()) {
            configs.getUsers().add((AtsUser)user);
        }
        ArtifactReadable atsAdminArt = (ArtifactReadable)this.atsApi.getQueryService().getArtifact((ArtifactId)AtsUserGroups.AtsAdmin);
        if (atsAdminArt != null) {
            for (ArtifactReadable member : atsAdminArt.getRelated(CoreRelationTypes.Users_User)) {
                configs.getAtsAdmins().add(member);
            }
        }
        HashMap<Long, ArtifactReadable> idToArtifact = new HashMap<Long, ArtifactReadable>();
        List configArts = Collections.castAll((Collection)this.atsApi.getQueryService().getArtifacts((BranchId)this.atsApi.getAtsBranch(), false, new ArtifactTypeToken[]{AtsArtifactTypes.TeamDefinition, AtsArtifactTypes.Version, AtsArtifactTypes.ActionableItem}));
        for (ArtifactReadable configArtId : configArts) {
            if (this.atsApi.getStoreService().isOfType((ArtifactId)configArtId, new ArtifactTypeId[]{AtsArtifactTypes.TeamDefinition})) {
                JaxTeamDefinition teamDef = this.createJaxTeamDefinition(configArtId);
                configs.addTeamDef(teamDef);
            } else if (this.atsApi.getStoreService().isOfType((ArtifactId)configArtId, new ArtifactTypeId[]{AtsArtifactTypes.ActionableItem})) {
                JaxActionableItem ai = this.createJaxActionableItem(configArtId);
                configs.addAi(ai);
            } else if (this.atsApi.getStoreService().isOfType((ArtifactId)configArtId, new ArtifactTypeId[]{AtsArtifactTypes.Version})) {
                JaxVersion version = this.createJaxVersion(configArtId);
                configs.addVersion(version);
            }
            idToArtifact.put(configArtId.getId(), configArtId);
        }
        this.addTeamDefinitionChildrenWIthRecurse(AtsArtifactToken.TopTeamDefinition.getId(), idToArtifact, configs, teamDefIds);
        configs.setTopTeamDefinition((ArtifactId)AtsArtifactToken.TopTeamDefinition);
        this.addActionableItemChildrenWIthRecurse(AtsArtifactToken.TopActionableItem.getId(), idToArtifact, configs, aiIds);
        configs.setTopActionableItem((ArtifactId)AtsArtifactToken.TopActionableItem);
        return configs;
    }

    private JaxTeamDefinition addTeamDefinitionChildrenWIthRecurse(Long teamDefId, Map<Long, ArtifactReadable> idToArtifact, AtsConfigurations configs, List<Long> teamDefIds) {
        ArtifactReadable teamDef = idToArtifact.get(teamDefId);
        if (teamDef != null && teamDef.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamDefinition})) {
            JaxTeamDefinition jaxTeamDef = (JaxTeamDefinition)configs.getIdToTeamDef().get(teamDefId);
            for (Long childId : teamDef.getChildrentIds()) {
                JaxTeamDefinition child;
                if (!teamDefIds.contains(childId) || (child = this.addTeamDefinitionChildrenWIthRecurse(childId, idToArtifact, configs, teamDefIds)) == null) continue;
                child.setParentId(teamDefId);
                jaxTeamDef.addChild(child);
            }
            for (Long versionId : this.atsApi.getRelationResolver().getRelatedIds((ArtifactId)teamDef, AtsRelationTypes.TeamDefinitionToVersion_Version)) {
                jaxTeamDef.addVersion(versionId);
                JaxVersion version = (JaxVersion)configs.getIdToVersion().get(versionId);
                version.setTeamDefId(teamDefId);
            }
            for (Long aiId : this.atsApi.getRelationResolver().getRelatedIds((ArtifactId)teamDef, AtsRelationTypes.TeamActionableItem_ActionableItem)) {
                JaxActionableItem jai = (JaxActionableItem)configs.getIdToAi().get(aiId);
                if (jai == null) continue;
                jaxTeamDef.addAi(aiId);
                jai.setTeamDefId(teamDefId);
            }
            return jaxTeamDef;
        }
        return null;
    }

    private JaxTeamDefinition createJaxTeamDefinition(ArtifactReadable teamDefArt) {
        JaxTeamDefinition jaxTeamDef = new JaxTeamDefinition();
        jaxTeamDef.setName(teamDefArt.getName());
        jaxTeamDef.setId(teamDefArt.getId());
        jaxTeamDef.setGuid(teamDefArt.getGuid());
        jaxTeamDef.setActive(((Boolean)teamDefArt.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.Active, (Object)true)).booleanValue());
        jaxTeamDef.setWorkType((String)teamDefArt.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.WorkType, (Object)""));
        for (ArtifactToken ai : this.atsApi.getRelationResolver().getRelated((ArtifactId)teamDefArt, AtsRelationTypes.TeamActionableItem_ActionableItem)) {
            jaxTeamDef.getAis().add(ai.getId());
        }
        return jaxTeamDef;
    }

    private JaxVersion createJaxVersion(ArtifactReadable verArt) {
        JaxVersion jaxVersion = new JaxVersion();
        jaxVersion.setName(verArt.getName());
        jaxVersion.setId(verArt.getId());
        jaxVersion.setGuid(verArt.getGuid());
        jaxVersion.setActive(((Boolean)verArt.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.Active, (Object)true)).booleanValue());
        return jaxVersion;
    }

    private JaxActionableItem createJaxActionableItem(ArtifactReadable aiArt) {
        JaxActionableItem jaxAi = new JaxActionableItem();
        jaxAi.setName(aiArt.getName());
        jaxAi.setId(aiArt.getId());
        jaxAi.setGuid(aiArt.getGuid());
        jaxAi.setDescription((String)aiArt.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.Description, (Object)""));
        jaxAi.setActive(((Boolean)aiArt.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.Active, (Object)true)).booleanValue());
        return jaxAi;
    }

    private JaxActionableItem addActionableItemChildrenWIthRecurse(Long aiId, Map<Long, ArtifactReadable> idToArtifact, AtsConfigurations configs, List<Long> aiIds) {
        ArtifactReadable aiArt = idToArtifact.get(aiId);
        if (aiArt != null && aiArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.ActionableItem})) {
            JaxActionableItem jaxAi = (JaxActionableItem)configs.getIdToAi().get(aiId);
            for (Long childId : aiArt.getChildrentIds()) {
                JaxActionableItem child;
                if (!aiIds.contains(childId) || (child = this.addActionableItemChildrenWIthRecurse(childId, idToArtifact, configs, aiIds)) == null) continue;
                child.setParentId(aiId);
                jaxAi.addChild(child);
            }
            return jaxAi;
        }
        return null;
    }

    public XResultData configAtsDatabase(AtsApi atsApi) {
        if (this.isAtsBaseCreated()) {
            XResultData results = new XResultData();
            results.error("ATS base config has already been completed");
            return results;
        }
        AtsDatabaseConfig config = new AtsDatabaseConfig(atsApi, this.orcsApi);
        return config.run();
    }
}

