/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;

@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class OAuthJSONProvider
implements MessageBodyWriter<Object>,
MessageBodyReader<Object> {
    public long getSize(Object obj, Class<?> clt, Type t, Annotation[] anns, MediaType mt) {
        return -1L;
    }

    public boolean isWriteable(Class<?> cls, Type t, Annotation[] anns, MediaType mt) {
        return cls == ClientAccessToken.class || cls == OAuthError.class;
    }

    public void writeTo(Object obj, Class<?> cls, Type t, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        if (obj instanceof ClientAccessToken) {
            this.writeAccessToken((ClientAccessToken)obj, os);
        } else {
            this.writeOAuthError((OAuthError)obj, os);
        }
    }

    private void writeOAuthError(OAuthError obj, OutputStream os) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        this.appendJsonPair(sb, "error", obj.getError());
        if (obj.getErrorDescription() != null) {
            sb.append(",");
            this.appendJsonPair(sb, "error_description", obj.getErrorDescription());
        }
        if (obj.getErrorUri() != null) {
            sb.append(",");
            this.appendJsonPair(sb, "error_uri", obj.getErrorUri());
        }
        sb.append("}");
        String result = sb.toString();
        os.write(result.getBytes("UTF-8"));
        os.flush();
    }

    private void writeAccessToken(ClientAccessToken obj, OutputStream os) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        this.appendJsonPair(sb, "access_token", obj.getTokenKey());
        sb.append(",");
        this.appendJsonPair(sb, "token_type", obj.getTokenType());
        if (obj.getExpiresIn() != -1L) {
            sb.append(",");
            this.appendJsonPair(sb, "expires_in", obj.getExpiresIn(), false);
        }
        if (obj.getApprovedScope() != null) {
            sb.append(",");
            this.appendJsonPair(sb, "scope", obj.getApprovedScope());
        }
        if (obj.getRefreshToken() != null) {
            sb.append(",");
            this.appendJsonPair(sb, "refresh_token", obj.getRefreshToken());
        }
        Map<String, String> parameters = obj.getParameters();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            sb.append(",");
            this.appendJsonPair(sb, entry.getKey(), entry.getValue());
        }
        sb.append("}");
        String result = sb.toString();
        os.write(result.getBytes("UTF-8"));
        os.flush();
    }

    private void appendJsonPair(StringBuilder sb, String key, Object value) {
        this.appendJsonPair(sb, key, value, true);
    }

    private void appendJsonPair(StringBuilder sb, String key, Object value, boolean valueQuote) {
        sb.append("\"").append(key).append("\"");
        sb.append(":");
        if (valueQuote) {
            sb.append("\"");
        }
        sb.append(value);
        if (valueQuote) {
            sb.append("\"");
        }
    }

    public boolean isReadable(Class<?> cls, Type t, Annotation[] anns, MediaType mt) {
        return Map.class.isAssignableFrom(cls) || ClientAccessToken.class.isAssignableFrom(cls);
    }

    public Object readFrom(Class<Object> cls, Type t, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException, WebApplicationException {
        Map<String, String> params = this.readJSONResponse(is);
        if (Map.class.isAssignableFrom(cls)) {
            return params;
        }
        ClientAccessToken token = OAuthClientUtils.fromMapToClientToken(params);
        if (token == null) {
            throw new WebApplicationException(500);
        }
        return token;
    }

    public Map<String, String> readJSONResponse(InputStream is) throws IOException {
        String str = IOUtils.readStringFromStream((InputStream)is).trim();
        if (str.length() == 0) {
            return Collections.emptyMap();
        }
        if (!str.startsWith("{") || !str.endsWith("}")) {
            throw new ProcessingException("JSON Sequence is broken");
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        str = str.substring(1, str.length() - 1).trim();
        String[] jsonPairs = str.split(",");
        for (int i = 0; i < jsonPairs.length; ++i) {
            String value;
            String pair = jsonPairs[i].trim();
            if (pair.length() == 0) continue;
            int index = pair.indexOf(":");
            String key = pair.substring(0, index).trim();
            if (key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            if ((value = pair.substring(index + 1)).startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            map.put(key, value);
        }
        return map;
    }
}

