/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.refresh;

import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class RefreshTokenGrantHandler
implements AccessTokenGrantHandler {
    private OAuthDataProvider dataProvider;
    private boolean partialMatchScopeValidation;

    public void setDataProvider(OAuthDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Override
    public List<String> getSupportedGrantTypes() {
        return Collections.singletonList("refresh_token");
    }

    @Override
    public ServerAccessToken createAccessToken(Client client, MultivaluedMap<String, String> params) throws OAuthServiceException {
        String refreshToken = (String)params.getFirst((Object)"refresh_token");
        List<String> requestedScopes = OAuthUtils.getRequestedScopes(client, (String)params.getFirst((Object)"scope"), this.partialMatchScopeValidation);
        return this.dataProvider.refreshAccessToken(client, refreshToken, requestedScopes);
    }

    public void setPartialMatchScopeValidation(boolean partialMatchScopeValidation) {
        this.partialMatchScopeValidation = partialMatchScopeValidation;
    }
}

