/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.TableEnum;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaTxGetPrior;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;

public class TxGetPriorSqlHandler
extends SqlHandler<CriteriaTxGetPrior> {
    private CriteriaTxGetPrior criteria;
    private String txdAlias;

    @Override
    public void setData(CriteriaTxGetPrior criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        this.txdAlias = writer.getMainTableAlias(TableEnum.TX_DETAILS_TABLE);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        BranchId branch = this.criteria.getTxId().getBranch();
        writer.writeEqualsParameterAnd(this.txdAlias, "branch_id", branch);
        writer.write(this.txdAlias);
        writer.write(".transaction_id = ");
        writer.write("(SELECT max(transaction_id) FROM ");
        writer.writeTableNoAlias(TableEnum.TX_DETAILS_TABLE);
        writer.write(" WHERE ");
        writer.writeEqualsParameterAnd("branch_id", branch);
        writer.write("transaction_id < ?");
        writer.addParameter(this.criteria.getTxId());
        writer.write(")");
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.TX_ID.ordinal();
    }
}

