/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.List;
import org.eclipse.osee.framework.core.enums.TableEnum;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelationTypeNotExists;
import org.eclipse.osee.orcs.db.internal.search.handlers.AbstractRelationSqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;

public class RelationTypeNotExistsSqlHandler
extends AbstractRelationSqlHandler<CriteriaRelationTypeNotExists> {
    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        super.addPredicates(writer);
        writer.write("NOT EXISTS (SELECT 1 FROM ");
        String relAlias = writer.writeTable(TableEnum.RELATION_TABLE);
        writer.write(", ");
        String txsAlias = writer.writeTable(TableEnum.TXS_TABLE);
        writer.write(" WHERE ");
        writer.writeEqualsParameterAnd(relAlias, "rel_link_type_id", ((CriteriaRelationTypeNotExists)this.criteria).getType());
        List<String> aliases = writer.getAliases(TableEnum.ARTIFACT_TABLE);
        int aSize = aliases.size();
        int index = 0;
        while (index < aSize) {
            String artAlias = aliases.get(index);
            writer.writeEquals(relAlias, "a_art_id", artAlias, "art_id");
            writer.write(" OR ");
            writer.writeEquals(relAlias, "b_art_id", artAlias, "art_id");
            if (index + 1 < aSize) {
                writer.writeAndLn();
            }
            ++index;
        }
        writer.writeAndLn();
        writer.writeEquals(relAlias, txsAlias, "gamma_id");
        writer.writeAndLn();
        writer.writeTxBranchFilter(txsAlias);
        writer.write(")");
    }
}

