/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.data;

import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.Tuple2Type;
import org.eclipse.osee.framework.core.data.Tuple3Type;
import org.eclipse.osee.framework.core.data.Tuple4Type;
import org.eclipse.osee.framework.core.data.TupleTypeId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.ArtifactDataImpl;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.DataProxy;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.core.ds.TupleData;
import org.eclipse.osee.orcs.core.ds.VersionData;
import org.eclipse.osee.orcs.core.ds.VersionDataImpl;
import org.eclipse.osee.orcs.data.ArtifactTypes;
import org.eclipse.osee.orcs.data.RelationTypes;
import org.eclipse.osee.orcs.db.internal.OrcsObjectFactory;
import org.eclipse.osee.orcs.db.internal.loader.data.AttributeDataImpl;
import org.eclipse.osee.orcs.db.internal.loader.data.RelationDataImpl;
import org.eclipse.osee.orcs.db.internal.loader.data.TupleDataImpl;
import org.eclipse.osee.orcs.db.internal.proxy.AttributeDataProxyFactory;

public class OrcsObjectFactoryImpl
implements OrcsObjectFactory {
    private final AttributeDataProxyFactory proxyFactory;
    private final RelationTypes relationTypes;
    private final ArtifactTypes artifactTypes;

    public OrcsObjectFactoryImpl(AttributeDataProxyFactory proxyFactory, RelationTypes relationTypes, ArtifactTypes artifactTypes) {
        this.proxyFactory = proxyFactory;
        this.relationTypes = relationTypes;
        this.artifactTypes = artifactTypes;
    }

    @Override
    public VersionData createVersion(BranchId branchId, TransactionId txId, GammaId gamma, boolean historical) {
        return this.createVersion(branchId, txId, gamma, historical, TransactionId.SENTINEL);
    }

    @Override
    public VersionData createDefaultVersionData() {
        return this.createVersion(BranchId.SENTINEL, TransactionId.SENTINEL, GammaId.SENTINEL, false, TransactionId.SENTINEL);
    }

    @Override
    public VersionData createCopy(VersionData other) {
        return this.createVersion(other.getBranch(), other.getTransactionId(), other.getGammaId(), other.isHistorical(), other.getStripeId());
    }

    private VersionData createVersion(BranchId branchId, TransactionId txId, GammaId gamma, boolean historical, TransactionId stripeId) {
        VersionDataImpl version = new VersionDataImpl();
        version.setBranch(branchId);
        version.setTransactionId(txId);
        version.setGammaId(gamma);
        version.setHistorical(historical);
        version.setStripeId(stripeId);
        return version;
    }

    @Override
    public ArtifactData createArtifactData(VersionData version, Integer generateArtId, ArtifactTypeToken artifactType, ModificationType modType, String guidToSet, ApplicabilityId applicId) {
        return this.createArtifactFromRow(version, generateArtId, artifactType, modType, artifactType, modType, guidToSet, applicId);
    }

    @Override
    public ArtifactData createCopy(ArtifactData source) {
        VersionData newVersion = this.createCopy(source.getVersion());
        return this.createArtifactFromRow(newVersion, source.getLocalId(), (ArtifactTypeToken)source.getType(), source.getModType(), (ArtifactTypeToken)source.getBaseType(), source.getBaseModType(), source.getGuid(), source.getApplicabilityId());
    }

    @Override
    public <T> AttributeData<T> createAttributeData(VersionData version, Integer id, AttributeTypeToken attributeType, ModificationType modType, ArtifactId artifactId, T value, String uri, ApplicabilityId applicId) {
        DataProxy proxy = this.proxyFactory.createProxy((AttributeTypeId)attributeType, value, uri);
        return this.createAttributeFromRow(version, id, attributeType, modType, attributeType, modType, artifactId, proxy, applicId);
    }

    @Override
    public <T> AttributeData<T> createCopy(AttributeData<T> source) {
        VersionData newVersion = this.createCopy(source.getVersion());
        AttributeTypeToken attributeType = (AttributeTypeToken)source.getType();
        DataProxy sourceProxy = source.getDataProxy();
        DataProxy newProxy = this.proxyFactory.createProxy((AttributeTypeId)attributeType, sourceProxy.getRawValue(), sourceProxy.getUri());
        return this.createAttributeFromRow(newVersion, source.getId().intValue(), attributeType, source.getModType(), (AttributeTypeToken)source.getBaseType(), source.getBaseModType(), source.getArtifactId(), newProxy, source.getApplicabilityId());
    }

    @Override
    public <T> AttributeData<T> createAttributeData(VersionData version, Integer generateArtId, AttributeTypeToken attributeType, ModificationType modType, ArtifactId artId, ApplicabilityId applicId) {
        DataProxy proxy = this.proxyFactory.createProxy((AttributeTypeId)attributeType, "", "");
        return this.createAttributeFromRow(version, generateArtId, attributeType, modType, attributeType, modType, artId, proxy, applicId);
    }

    @Override
    public RelationData createRelationData(VersionData version, Integer id, RelationTypeToken relationType, ModificationType modType, ArtifactId aArtId, ArtifactId bArtId, String rationale, ApplicabilityId applicId) {
        return this.createRelationData(version, id, relationType, modType, relationType, modType, aArtId, bArtId, rationale, applicId);
    }

    @Override
    public RelationData createRelationData(VersionData version, Integer id, RelationTypeId relationType, ModificationType modType, ArtifactId aArtId, ArtifactId bArtId, String rationale, ApplicabilityId applicId) {
        return this.createRelationData(version, id, (RelationTypeToken)this.relationTypes.get((Id)relationType), modType, aArtId, bArtId, rationale, applicId);
    }

    private ArtifactData createArtifactFromRow(VersionData version, int generateArtId, ArtifactTypeToken artifactType, ModificationType modType, ArtifactTypeToken baseArtifactType, ModificationType baseModType, String guid, ApplicabilityId applicId) {
        ArtifactDataImpl data = new ArtifactDataImpl(version);
        data.setLocalId(Integer.valueOf(generateArtId));
        data.setType((Id)artifactType);
        data.setBaseType((Id)baseArtifactType);
        data.setModType(modType);
        data.setBaseModType(baseModType);
        data.setGuid(guid);
        data.setApplicabilityId(applicId);
        return data;
    }

    private <T> AttributeData<T> createAttributeFromRow(VersionData version, int id, AttributeTypeToken attributeType, ModificationType modType, AttributeTypeToken baseAttributeType, ModificationType baseModType, ArtifactId artifactId, DataProxy<T> proxy, ApplicabilityId applicId) {
        AttributeDataImpl data = new AttributeDataImpl(version);
        data.setLocalId(id);
        data.setType((Id)attributeType);
        data.setBaseType((Id)baseAttributeType);
        data.setModType(modType);
        data.setBaseModType(baseModType);
        data.setArtifactId(artifactId);
        data.setDataProxy(proxy);
        data.setApplicabilityId(applicId);
        return data;
    }

    private RelationData createRelationData(VersionData version, Integer id, RelationTypeToken relationType, ModificationType modType, RelationTypeToken baseRelationType, ModificationType baseModType, ArtifactId aArtId, ArtifactId bArtId, String rationale, ApplicabilityId applicId) {
        RelationDataImpl data = new RelationDataImpl(version);
        data.setLocalId(id);
        data.setType((Id)relationType);
        data.setBaseType((Id)baseRelationType);
        data.setModType(modType);
        data.setBaseModType(baseModType);
        data.setArtIdA(aArtId);
        data.setArtIdB(bArtId);
        Conditions.assertNotNull((Object)rationale, (String)"rationale can't be null for RelationData id [%s], type [%s], aArtId [%s], bArtId", (Object[])new Object[]{id, relationType, aArtId, bArtId});
        data.setRationale(rationale);
        data.setApplicabilityId(applicId);
        return data;
    }

    @Override
    public RelationData createCopy(RelationData source) {
        VersionData newVersion = this.createCopy(source.getVersion());
        return this.createRelationData(newVersion, source.getLocalId(), (RelationTypeToken)source.getType(), source.getModType(), (RelationTypeToken)source.getBaseType(), source.getBaseModType(), source.getArtifactIdA(), source.getArtifactIdB(), source.getRationale(), source.getApplicabilityId());
    }

    private TupleData createTuple2Data(VersionData version, BranchId branch, TupleTypeId tupleType, Long e1, Long e2) {
        TupleDataImpl data = new TupleDataImpl(version);
        data.setBaseModType(ModificationType.NEW);
        data.setModType(ModificationType.NEW);
        data.setApplicabilityId(ApplicabilityId.BASE);
        data.setTupleType(tupleType);
        data.getVersion().setGammaId(GammaId.valueOf((Long)Lib.generateUuid()));
        data.getVersion().setBranch(branch);
        data.setElement1(e1);
        data.setElement2(e2);
        return data;
    }

    @Override
    public TupleData createTuple2Data(VersionData version, BranchId branch, Tuple2Type<?, ?> tupleType, Long e1, Long e2) {
        return this.createTuple2Data(version, branch, (TupleTypeId)tupleType, e1, e2);
    }

    @Override
    public TupleData createTuple3Data(VersionData version, BranchId branch, Tuple3Type<?, ?, ?> tupleType, Long e1, Long e2, Long e3) {
        TupleData data = this.createTuple2Data(version, branch, (TupleTypeId)tupleType, e1, e2);
        data.setElement3(e3);
        return data;
    }

    @Override
    public TupleData createTuple4Data(VersionData version, BranchId branch, Tuple4Type<?, ?, ?, ?> tupleType, Long e1, Long e2, Long e3, Long e4) {
        TupleData data = this.createTuple2Data(version, branch, (TupleTypeId)tupleType, e1, e2);
        data.setElement3(e3);
        data.setElement4(e4);
        return data;
    }

    @Override
    public ArtifactData createArtifactData(VersionData version, Integer generateArtId, long artifactType, ModificationType modType, String guidToSet, ApplicabilityId applicId) {
        return this.createArtifactData(version, generateArtId, (ArtifactTypeToken)this.artifactTypes.get(Long.valueOf(artifactType)), modType, guidToSet, applicId);
    }
}

