/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import com.google.common.base.Supplier;
import java.net.URL;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcMigrationResource;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.SystemPreferences;
import org.eclipse.osee.orcs.core.ds.DataStoreInfo;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreCallable;
import org.eclipse.osee.orcs.db.internal.resource.ResourceConstants;
import org.eclipse.osee.orcs.db.internal.util.DataStoreInfoImpl;

public class FetchDatastoreInfoCallable
extends AbstractDatastoreCallable<DataStoreInfo> {
    private final Supplier<Iterable<JdbcMigrationResource>> schemaProvider;
    private final SystemPreferences preferences;

    public FetchDatastoreInfoCallable(Log logger, JdbcClient jdbcClient, Supplier<Iterable<JdbcMigrationResource>> schemaProvider, SystemPreferences preferences) {
        super(logger, null, jdbcClient);
        this.schemaProvider = schemaProvider;
        this.preferences = preferences;
    }

    public DataStoreInfo call() throws Exception {
        DataStoreInfoImpl dataStoreInfo = new DataStoreInfoImpl();
        HashMap<String, String> props = new HashMap<String, String>();
        this.addInfoProperties(props);
        this.addDbMetaData(props);
        dataStoreInfo.setProperties(props);
        HashSet<URL> configResources = new HashSet<URL>();
        dataStoreInfo.setConfigurationResources(configResources);
        for (JdbcMigrationResource resource : (Iterable)this.schemaProvider.get()) {
            configResources.add(resource.getLocation());
        }
        return dataStoreInfo;
    }

    private void addInfoProperties(Map<String, String> props) {
        for (String key : this.preferences.getKeys()) {
            String value = this.preferences.getValue(key);
            if (!Strings.isValid((String)value)) {
                value = "";
            }
            props.put(key, value);
        }
        props.put("osee.db.guid", this.preferences.getSystemUuid());
        props.put("ds.binary.data.path", ResourceConstants.getBinaryDataPath(this.preferences));
        props.put("ds.attribute.data.path", ResourceConstants.getAttributeDataPath(this.preferences));
        props.put("ds.exchange.data.path", ResourceConstants.getExchangeDataPath(this.preferences));
    }

    private void addDbMetaData(Map<String, String> props) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JdbcConnection connection = this.getJdbcClient().getConnection();){
                DatabaseMetaData meta = connection.getMetaData();
                props.put("db.connection.url", meta.getURL());
                props.put("db.connection.username", meta.getUserName());
                props.put("db.product.name", meta.getDatabaseProductName());
                props.put("db.product.version", meta.getDatabaseProductVersion());
                props.put("db.driver.name", meta.getDriverName());
                props.put("db.driver.version", meta.getDriverVersion());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }
}

