/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal.wordupdate;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.define.api.WordTemplateContentData;
import org.eclipse.osee.define.rest.internal.wordupdate.WordMLApplicabilityHandler;
import org.eclipse.osee.define.rest.internal.wordupdate.WordMlLinkHandler;
import org.eclipse.osee.define.rest.internal.wordupdate.WordUtilities;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.model.type.LinkType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class WordTemplateContentRendererHandler {
    public static final String PGNUMTYPE_START_1 = "<w:pgNumType [^>]*w:start=\"1\"/>";
    public static final String PL_STYLE_WITH_RETURN = "<w:rPr><w:rStyle w:val=\"ProductLineApplicability\"((?=/>)(/>)|(.*?</w:rStyle>)).*?</w:rPr>";
    public static final String PL_STYLE = "<w:rStyle w:val=\"ProductLineApplicability\"((?=/>)(/>)|(.*?</w:rStyle>))";
    public static final String PL_HIGHLIGHT = "<w:highlight w:val=\"light-gray\"></w:highlight><w:shd w:color=\"auto\" w:fill=\"BFBFBF\" w:val=\"clear\"></w:shd>";
    public static final String EMPTY_PARAGRAPHS = "<w:r wsp:rsidRPr=\"\\d+\"><w:t></w:t></w:r>";
    public static final String EXTRA_SPACES = "<w:r><w:t> </w:t></w:r>";
    private final OrcsApi orcsApi;
    private final Log logger;
    private WordMLApplicabilityHandler applicHandler;

    public WordTemplateContentRendererHandler(OrcsApi orcsApi, Log logger) {
        this.orcsApi = orcsApi;
        this.logger = logger;
    }

    public Pair<String, Set<String>> renderWordML(WordTemplateContentData wtcData) {
        TransactionId txId = wtcData.getTxId();
        if (txId == null || txId.isInvalid()) {
            txId = TransactionId.SENTINEL;
        }
        ArtifactReadable artifact = null;
        artifact = txId.equals(TransactionId.SENTINEL) ? (ArtifactReadable)this.orcsApi.getQueryFactory().fromBranch(wtcData.getBranch()).andId(ArtifactId.valueOf((Long)wtcData.getArtId())).includeDeletedArtifacts().includeDeletedAttributes().getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL) : (ArtifactReadable)this.orcsApi.getQueryFactory().fromBranch(wtcData.getBranch()).fromTransaction(txId).andId(ArtifactId.valueOf((Long)wtcData.getArtId())).includeDeletedArtifacts().includeDeletedAttributes().getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (artifact.isValid()) {
            HashSet<String> unknownGuids = new HashSet<String>();
            String data = (String)artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.WordTemplateContent, DeletionFlag.INCLUDE_DELETED, null);
            if (data == null && wtcData.getIsEdit()) {
                data = this.orcsApi.getOrcsTypes().getAttributeTypes().getDefaultValue((AttributeTypeId)CoreAttributeTypes.WordTemplateContent);
            }
            if (data != null) {
                int lastIndex;
                data = WordUtilities.reassignBinDataID(data);
                LinkType link = wtcData.getLinkType() != null ? LinkType.valueOf((String)wtcData.getLinkType()) : null;
                data = WordMlLinkHandler.link(this.orcsApi.getQueryFactory(), link, artifact, data, wtcData.getTxId(), wtcData.getSessionId(), unknownGuids, wtcData.getPresentationType(), wtcData.getPermanentLinkUrl());
                data = WordUtilities.reassignBookMarkID(data);
                if (wtcData.getIsEdit()) {
                    data = data.replaceAll("<w:p[^>]*><w:pPr><w:spacing w:after=\"[\\d]*\"[^>]*>(</w:spacing>)*<w:sectPr[^>]*>(<w:r><w:t>)?<w:ftr[^>]*>[\\s\\S]+</w:ftr>[\\s\\S]+</w:sectPr></w:pPr></w:p>", "");
                }
                data = data.replaceAll("<w:sectPr[^>]*><w:ftr[\\s\\S]+?</w:ftr>[\\s\\S]+?</w:sectPr>", "");
                data = data.replaceAll("<w:p>[\\s||\\S]+?<w:r><w:t>NO DATA RIGHTS ARTIFACT FOUND</w:t></w:r>[\\s\\S]+?</w:p>", "");
                if (wtcData.getIsEdit() && !data.contains("<w:tbl>") && (lastIndex = data.lastIndexOf("<w:p wsp:rsidR=")) != -1) {
                    String temp = data.substring(lastIndex);
                    temp = temp.replaceAll("<w:p[^>]*>(<w:pPr><w:spacing[^>]*></w:spacing></w:pPr>)?</w:p>", "");
                    data = String.valueOf(data.substring(0, lastIndex)) + temp;
                }
                if (!wtcData.getIsEdit() && (wtcData.getBranch().getViewId().notEqual((Id)ArtifactId.SENTINEL) || this.isWtcViewIdValid(wtcData))) {
                    if (this.applicHandler == null) {
                        this.applicHandler = new WordMLApplicabilityHandler(this.orcsApi, this.logger, wtcData.getBranch(), wtcData.getViewId());
                    }
                    data = data.replaceAll(PL_STYLE_WITH_RETURN, "");
                    data = data.replaceAll(PL_STYLE, "");
                    data = data.replaceAll(PL_HIGHLIGHT, "");
                    data = this.applicHandler.previewValidApplicabilityContent(data);
                    data = data.replaceAll(EMPTY_PARAGRAPHS, "");
                }
                data = data.concat(wtcData.getFooter());
                if (!wtcData.getIsEdit()) {
                    data = data.replaceAll(PGNUMTYPE_START_1, "");
                }
                return new Pair((Object)data, unknownGuids);
            }
        }
        return null;
    }

    private boolean isWtcViewIdValid(WordTemplateContentData wtcData) {
        return wtcData.getViewId() != null && wtcData.getViewId().notEqual((Id)ArtifactId.SENTINEL);
    }
}

