/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal.util;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class ComponentUtil {
    private final BranchId branchId;
    private final OrcsApi orcsApi;
    private ArtifactReadable mpCsci;
    private Collection<ArtifactReadable> mpComponents;
    private boolean wasLoaded;

    public ComponentUtil(BranchId branchId, OrcsApi providedOrcs) {
        this.branchId = branchId;
        this.mpComponents = null;
        this.wasLoaded = false;
        this.mpCsci = null;
        this.orcsApi = providedOrcs;
    }

    private synchronized void load() {
        this.wasLoaded = true;
        this.mpCsci = (ArtifactReadable)this.orcsApi.getQueryFactory().fromBranch(this.branchId).andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.Component}).andNameEquals("MP CSCI").getResults().getExactlyOne();
        this.mpComponents = this.mpCsci.getDescendants();
    }

    private void ensureLoaded() {
        if (!this.wasLoaded) {
            this.load();
        }
    }

    public String getQualifiedComponentName(ArtifactReadable component) {
        this.ensureLoaded();
        if (component.getParent().equals(this.mpCsci)) {
            return component.getName();
        }
        return String.valueOf(component.getParent().getName()) + "." + component.getName();
    }

    public String getQualifiedComponentNames(ArtifactReadable requirement) {
        this.ensureLoaded();
        ResultSet components = requirement.getRelated(CoreRelationTypes.Allocation__Component);
        StringBuilder strB = new StringBuilder(20);
        for (ArtifactReadable component : components) {
            if (!this.mpComponents.contains(component)) continue;
            strB.append(this.getQualifiedComponentName(component));
            strB.append(", ");
        }
        return strB.length() == 0 ? null : strB.substring(0, strB.length() - 2);
    }

    public Collection<ArtifactReadable> getComponents() {
        this.ensureLoaded();
        return this.mpComponents;
    }
}

