/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.app.OseeAppletPage;
import org.eclipse.osee.define.rest.internal.SafetyStreamingOutput;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.IResourceRegistry;
import org.eclipse.osee.orcs.OrcsApi;

@Path(value="/")
public final class SystemSafetyResource {
    private final OrcsApi orcsApi;
    private final IResourceRegistry resourceRegistry;
    private final ActivityLog activityLog;

    public SystemSafetyResource(ActivityLog activityLog, IResourceRegistry resourceRegistry, OrcsApi orcsApi) {
        this.activityLog = activityLog;
        this.resourceRegistry = resourceRegistry;
        this.orcsApi = orcsApi;
    }

    @Path(value="safety")
    @GET
    @Produces(value={"application/xml"})
    public Response getSystemSafetyReport(@QueryParam(value="branch") BranchId branchId, @QueryParam(value="code_root") String codeRoot, @DefaultValue(value="on") @QueryParam(value="style") String validate) {
        SafetyStreamingOutput streamingOutput = new SafetyStreamingOutput(this.activityLog, this.orcsApi, branchId, codeRoot, validate);
        Response.ResponseBuilder builder = Response.ok((Object)streamingOutput);
        builder.header("Content-Disposition", (Object)"attachment; filename=Safety_Report.xml");
        return builder.build();
    }

    @Path(value="ui/safety")
    @GET
    @Produces(value={"text/html"})
    public String getApplet() {
        OseeAppletPage pageUtil = new OseeAppletPage(this.orcsApi.getQueryFactory().branchQuery());
        return pageUtil.realizeApplet(this.resourceRegistry, "systemSafetyReport.html", this.getClass());
    }
}

