/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.define.api.ParagraphNumberComparator;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelColumn;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.ArtifactTypes;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;

public final class PublishLowHighReqStreamingOutput
implements StreamingOutput {
    private final QueryFactory queryApi;
    private final OrcsTypes types;
    private final IOseeBranch branch;
    private final ActivityLog activityLog;
    private final Map<String, Integer> summarySubsystemCounter = new HashMap<String, Integer>();
    private final Map<String, Integer> summaryTraceCounter = new HashMap<String, Integer>();
    private final Map<String, Integer> summaryAllocationCounter = new HashMap<String, Integer>();
    private ExcelXmlWriter writer;
    private final Collection<ArtifactTypeToken> includeOnlyArtifactTypes;
    private final String REQUIREMENT_TRACE_TYPE = "Requirement Trace";
    private final String ALLOCATION_TRACE_TYPE = "Allocation Trace";
    private final Map<String, ArtifactTypeToken> allTypesMap = new HashMap<String, ArtifactTypeToken>();

    public PublishLowHighReqStreamingOutput(ActivityLog activityLog, OrcsApi orcsApi, BranchId branch, String selectedTypes) {
        this.activityLog = activityLog;
        this.queryApi = orcsApi.getQueryFactory();
        BranchQuery query = orcsApi.getQueryFactory().branchQuery();
        this.branch = (IOseeBranch)((BranchQuery)query.andId(branch)).getResultsAsId().getExactlyOne();
        this.types = orcsApi.getOrcsTypes();
        this.includeOnlyArtifactTypes = this.convertStringTypes(selectedTypes);
    }

    public void write(OutputStream output) {
        try {
            this.writer = new ExcelXmlWriter((Writer)new OutputStreamWriter(output, "UTF-8"));
            this.writeLowHighReqSheet();
            this.writeHighLowTraceSheet();
            this.writeSummarySheet();
            this.writer.endWorkbook();
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    private void writeLowHighReqSheet() throws IOException {
        this.writer.startSheet("Low to High Level Req", new ExcelColumn[]{ExcelColumn.newCol(null, (double)85.0), ExcelColumn.newCol(null, (double)400.0), ExcelColumn.newCol(null, (double)120.0), ExcelColumn.newCol(null, (double)120.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)85.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)400.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)350.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)250.0, (String)"OseeWraped")});
        QueryBuilder query = this.queryApi.fromBranch((BranchId)this.branch).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractSoftwareRequirement});
        Object[] objectArray = new String[8];
        objectArray[0] = "Low Level Requirement";
        objectArray[4] = "High Level Requirement";
        Object[] row = objectArray;
        this.writer.writeRow(row);
        row[0] = "Paragraph #";
        row[1] = "Req Name";
        row[2] = "Requirement Type";
        row[3] = "Qualification Method";
        row[4] = "Paragraph #";
        row[5] = "Req Name";
        row[6] = "Requirement Type";
        row[7] = "Subsystem";
        this.writer.writeRow(row);
        if (this.includeOnlyArtifactTypes == null) {
            this.writer.endSheet();
            return;
        }
        StringBuilder[] builtRows = new StringBuilder[8];
        int i = 0;
        while (i < 8) {
            builtRows[i] = new StringBuilder();
            ++i;
        }
        for (ArtifactReadable req : query.getResults().sort((Comparator)new ParagraphNumberComparator(this.activityLog))) {
            boolean foundType = false;
            for (ArtifactTypeToken type : this.includeOnlyArtifactTypes) {
                if (!req.isTypeEqual((ArtifactTypeId)type)) continue;
                foundType = true;
                break;
            }
            if (!foundType) continue;
            int i2 = 0;
            while (i2 < 8) {
                builtRows[i2].setLength(0);
                ++i2;
            }
            if (req.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber) > 0) {
                builtRows[0].append(req.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber));
            }
            builtRows[1].append(req.getName());
            builtRows[2].append(req.getArtifactType().getName());
            List qualificationMethods = req.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.QualificationMethod);
            if (qualificationMethods.size() > 0) {
                Iterator iter = qualificationMethods.iterator();
                builtRows[3].append((String)iter.next());
                while (iter.hasNext()) {
                    builtRows[3].append(",");
                    builtRows[3].append((String)iter.next());
                }
            } else {
                row[3] = "";
            }
            String newline = "";
            for (ArtifactReadable subSysReq : req.getRelated(CoreRelationTypes.Requirement_Trace__Higher_Level)) {
                builtRows[4].append(newline);
                builtRows[4].append(subSysReq.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber));
                builtRows[5].append(newline);
                builtRows[5].append(subSysReq.getName());
                builtRows[6].append(newline);
                builtRows[6].append(subSysReq.getArtifactType().getName());
                String subsystem = "Not specified";
                if (req.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.Subsystem) > 0) {
                    subsystem = subSysReq.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Subsystem);
                }
                builtRows[7].append(newline);
                builtRows[7].append(subsystem);
                newline = "\n";
            }
            int i3 = 0;
            while (i3 < 8) {
                row[i3] = builtRows[i3].toString();
                ++i3;
            }
            this.nullEmptyCells((String[])row);
            this.writer.writeRow(row);
        }
        this.writer.endSheet();
    }

    private void writeHighLowTraceSheet() throws IOException {
        this.writer.startSheet("High to Low Level Req", new ExcelColumn[]{ExcelColumn.newCol(null, (double)85.0), ExcelColumn.newCol(null, (double)400.0), ExcelColumn.newCol(null, (double)120.0), ExcelColumn.newCol(null, (double)120.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)120.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)85.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)400.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)350.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)250.0, (String)"OseeWraped")});
        QueryBuilder query = this.queryApi.fromBranch((BranchId)this.branch).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractSystemRequirement});
        Object[] objectArray = new String[9];
        objectArray[0] = "Higher Level Requirement";
        objectArray[5] = "Low Level Requirement";
        Object[] row = objectArray;
        this.writer.writeRow(row);
        row[0] = "Paragraph #";
        row[1] = "Req Name";
        row[2] = "Requirement Type";
        row[3] = "Subsystem";
        row[4] = "Relation Type";
        row[5] = "Paragraph #";
        row[6] = "Req Name";
        row[7] = "Requirement Type";
        row[8] = "Qualification Method";
        this.writer.writeRow(row);
        StringBuilder[] builtRows = new StringBuilder[9];
        int i = 0;
        while (i < 9) {
            builtRows[i] = new StringBuilder();
            ++i;
        }
        for (ArtifactReadable req : query.getResults().sort((Comparator)new ParagraphNumberComparator(this.activityLog))) {
            Iterator iter;
            List qualificationMethods;
            row[8] = "";
            row[7] = "";
            row[6] = "";
            row[5] = "";
            row[4] = "";
            row[3] = "";
            row[2] = "";
            row[1] = "";
            row[0] = "";
            int i2 = 0;
            while (i2 < 9) {
                builtRows[i2].setLength(0);
                ++i2;
            }
            if (req.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber) > 0) {
                builtRows[0].append(req.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber));
            }
            builtRows[1].append(req.getName());
            builtRows[2].append(req.getArtifactType().getName());
            String subsystem = "Not specified";
            if (req.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.Subsystem) > 0) {
                subsystem = req.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Subsystem);
            }
            builtRows[3].append(subsystem);
            Integer counter = this.summarySubsystemCounter.get(subsystem);
            counter = counter == null ? new Integer(1) : new Integer(counter + 1);
            this.summarySubsystemCounter.put(subsystem, counter);
            String newline = "";
            boolean foundTrace = false;
            for (ArtifactReadable subSysReq : req.getRelated(CoreRelationTypes.Requirement_Trace__Lower_Level)) {
                builtRows[4].append(newline);
                builtRows[4].append("Requirement Trace");
                builtRows[5].append(newline);
                if (subSysReq.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber) > 0) {
                    builtRows[5].append(subSysReq.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber));
                }
                builtRows[6].append(newline);
                builtRows[6].append(subSysReq.getName());
                builtRows[7].append(newline);
                builtRows[7].append(subSysReq.getArtifactType().getName());
                qualificationMethods = subSysReq.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.QualificationMethod);
                builtRows[8].append(newline);
                if (qualificationMethods.size() > 0) {
                    iter = qualificationMethods.iterator();
                    builtRows[8].append((String)iter.next());
                    while (iter.hasNext()) {
                        builtRows[8].append((String)iter.next());
                    }
                }
                newline = "\n";
                foundTrace = true;
            }
            if (foundTrace) {
                counter = this.summaryTraceCounter.get(subsystem);
                counter = counter == null ? new Integer(1) : new Integer(counter + 1);
                this.summaryTraceCounter.put(subsystem, counter);
            }
            foundTrace = false;
            for (ArtifactReadable subSysReq : req.getRelated(CoreRelationTypes.Allocation__Component)) {
                builtRows[4].append(newline);
                builtRows[4].append("Allocation Trace");
                builtRows[5].append(newline);
                if (subSysReq.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber) > 0) {
                    builtRows[5].append(subSysReq.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber));
                }
                builtRows[6].append(newline);
                builtRows[6].append(subSysReq.getName());
                builtRows[7].append(newline);
                builtRows[7].append(subSysReq.getArtifactType().getName());
                qualificationMethods = subSysReq.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.QualificationMethod);
                builtRows[8].append(newline);
                if (qualificationMethods.size() > 0) {
                    iter = qualificationMethods.iterator();
                    builtRows[8].append((String)iter.next());
                    while (iter.hasNext()) {
                        builtRows[8].append((String)iter.next());
                    }
                }
                newline = "\n";
                foundTrace = true;
            }
            if (foundTrace) {
                counter = this.summaryAllocationCounter.get(subsystem);
                counter = counter == null ? new Integer(1) : new Integer(counter + 1);
                this.summaryAllocationCounter.put(subsystem, counter);
            }
            int i3 = 0;
            while (i3 < 9) {
                row[i3] = builtRows[i3].toString();
                ++i3;
            }
            this.nullEmptyCells((String[])row);
            this.writer.writeRow(row);
        }
        this.writer.endSheet();
    }

    private void writeSummarySheet() throws IOException {
        Integer counter;
        this.writer.startSheet("Summary", new ExcelColumn[]{ExcelColumn.newCol(null, (double)300.0), ExcelColumn.newCol(null, (double)300.0, (String)"OseeWraped")});
        this.writer.writeRow(new Object[]{"Branch Name", this.branch.getName()});
        this.writer.writeRow(new Object[]{"Report Date", Calendar.getInstance().getTime()});
        this.writer.endRow();
        Object[] row = new String[]{"Subsystem", "Number of System requirements"};
        this.writer.writeRow(row);
        for (String subsystem : this.summarySubsystemCounter.keySet()) {
            row[0] = subsystem;
            counter = this.summarySubsystemCounter.get(subsystem);
            row[1] = counter.toString();
            this.writer.writeRow(row);
        }
        this.writer.endRow();
        row[0] = "Subsystem";
        row[1] = "Number of System requirements traced to software requirements";
        this.writer.writeRow(row);
        for (String subsystem : this.summaryTraceCounter.keySet()) {
            row[0] = subsystem;
            counter = this.summaryTraceCounter.get(subsystem);
            row[1] = counter.toString();
            this.writer.writeRow(row);
        }
        this.writer.endRow();
        row[0] = "Subsystem";
        row[1] = "Number of System requirements traced to allocation components";
        this.writer.writeRow(row);
        for (String subsystem : this.summaryAllocationCounter.keySet()) {
            row[0] = subsystem;
            counter = this.summaryAllocationCounter.get(subsystem);
            row[1] = counter.toString();
            this.writer.writeRow(row);
        }
        this.writer.endSheet();
    }

    private void nullEmptyCells(String[] row) {
        int i = 0;
        while (i < row.length) {
            String trimmed = row[i].trim().replaceAll("\n", "");
            if (!Strings.isValid((String)trimmed)) {
                row[i] = null;
            }
            ++i;
        }
    }

    private Collection<ArtifactTypeToken> convertStringTypes(String csvTypes) {
        if (this.allTypesMap.isEmpty()) {
            ArtifactTypes artifactTypes = this.types.getArtifactTypes();
            for (ArtifactTypeToken type : artifactTypes.getAll()) {
                this.allTypesMap.put(type.getName(), type);
            }
        }
        StringTokenizer parser = new StringTokenizer(csvTypes, ",");
        ArrayList<ArtifactTypeToken> theReturn = new ArrayList<ArtifactTypeToken>();
        while (parser.hasMoreTokens()) {
            ArtifactTypeToken type = this.allTypesMap.get(parser.nextToken());
            if (type == null) continue;
            theReturn.add(type);
        }
        if (theReturn.isEmpty()) {
            return null;
        }
        return theReturn;
    }
}

