/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.resolvers;

import org.eclipse.define.api.importing.RoughArtifact;
import org.eclipse.define.api.importing.RoughArtifactKind;
import org.eclipse.osee.define.rest.importing.resolvers.IArtifactImportResolver;
import org.eclipse.osee.define.rest.importing.resolvers.IRoughArtifactTranslator;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class NewArtifactImportResolver
implements IArtifactImportResolver {
    protected final TransactionBuilder transaction;
    protected final IRoughArtifactTranslator translator;
    private final ArtifactTypeToken primaryArtifactType;
    private final ArtifactTypeToken secondaryArtifactType;
    private final ArtifactTypeToken tertiaryArtifactType;
    private final ArtifactTypeToken quaternaryArtifactType;

    public NewArtifactImportResolver(TransactionBuilder transaction, IRoughArtifactTranslator translator, ArtifactTypeToken primaryArtifactType, ArtifactTypeToken secondaryArtifactType) {
        this.translator = translator;
        this.primaryArtifactType = primaryArtifactType;
        this.secondaryArtifactType = secondaryArtifactType;
        this.tertiaryArtifactType = secondaryArtifactType;
        this.quaternaryArtifactType = secondaryArtifactType;
        this.transaction = transaction;
    }

    public NewArtifactImportResolver(TransactionBuilder transaction, IRoughArtifactTranslator translator, ArtifactTypeToken primaryArtifactType, ArtifactTypeToken secondaryArtifactType, ArtifactTypeToken tertiaryArtifactType, ArtifactTypeToken quaternaryArtifactType) {
        this.translator = translator;
        this.primaryArtifactType = primaryArtifactType;
        this.secondaryArtifactType = secondaryArtifactType;
        this.tertiaryArtifactType = tertiaryArtifactType;
        this.quaternaryArtifactType = quaternaryArtifactType;
        this.transaction = transaction;
    }

    protected IRoughArtifactTranslator getTranslator() {
        return this.translator;
    }

    @Override
    public ArtifactId resolve(RoughArtifact roughArtifact, BranchId branch, ArtifactId realParent, ArtifactId root) {
        ArtifactTypeToken artifactType = this.getArtifactType(roughArtifact);
        roughArtifact.getResults().logf("New artifact resolved: [%s].", new Object[]{roughArtifact.getName()});
        ArtifactToken realArtifact = this.transaction.createArtifact(artifactType, roughArtifact.getName(), roughArtifact.getGuid());
        this.translator.translate(this.transaction, roughArtifact, (ArtifactId)realArtifact);
        return realArtifact;
    }

    protected ArtifactTypeToken getArtifactType(RoughArtifact art) {
        ArtifactTypeToken type = art.getType();
        if (!type.equals(ArtifactTypeId.SENTINEL)) {
            return type;
        }
        RoughArtifactKind kind = art.getRoughArtifactKind();
        switch (kind) {
            case PRIMARY: {
                return this.primaryArtifactType;
            }
            case SECONDARY: {
                return this.secondaryArtifactType;
            }
            case TERTIARY: {
                return this.tertiaryArtifactType;
            }
            case QUATERNARY: {
                return this.quaternaryArtifactType;
            }
            case CONTAINER: {
                return CoreArtifactTypes.Folder;
            }
        }
        throw new OseeCoreException("Unknown Artifact Kind " + kind, new Object[0]);
    }
}

