/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.parsers;

import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import org.eclipse.define.api.importing.RoughArtifact;
import org.eclipse.define.api.importing.RoughArtifactCollector;
import org.eclipse.define.api.importing.RoughArtifactKind;
import org.eclipse.osee.define.rest.importing.parsers.AbstractArtifactExtractor;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.OrcsApi;

public class NativeDocumentExtractor
extends AbstractArtifactExtractor {
    public String getDescription() {
        return "Extract the content of each native document as one artifact.";
    }

    @Override
    protected XResultData extractFromSource(OrcsApi orcsApi, XResultData results, URI source, RoughArtifactCollector collector) {
        String extension = Lib.getExtension((String)source.toASCIIString());
        String name = Lib.removeExtension((String)new File(source).getName());
        RoughArtifact roughArtifact = new RoughArtifact(orcsApi, results, RoughArtifactKind.PRIMARY, name);
        collector.addRoughArtifact(roughArtifact);
        roughArtifact.addAttribute((AttributeTypeToken)CoreAttributeTypes.Extension, extension);
        roughArtifact.addAttribute((AttributeTypeToken)CoreAttributeTypes.NativeContent, source);
        return results;
    }

    public FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return true;
            }
        };
    }

    public String getName() {
        return "General Documents (Any Format)";
    }

    public boolean usesTypeList() {
        return true;
    }
}

