/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.operations;

import java.io.File;
import java.util.Collection;
import org.eclipse.define.api.importing.IArtifactExtractor;
import org.eclipse.define.api.importing.RoughArtifact;
import org.eclipse.define.api.importing.RoughArtifactCollector;
import org.eclipse.define.api.importing.RoughArtifactKind;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.orcs.OrcsApi;

public class SourceToRoughArtifactOperation {
    private final OrcsApi orcsApi;
    private final IArtifactExtractor extractor;
    private final File sourceFile;
    private final RoughArtifactCollector collector;
    private final XResultData results;

    public SourceToRoughArtifactOperation(OrcsApi orcsApi, XResultData results, IArtifactExtractor extractor, File sourceFile, RoughArtifactCollector collector) {
        this.extractor = extractor;
        this.sourceFile = sourceFile;
        this.collector = collector;
        this.orcsApi = orcsApi;
        this.results = results;
    }

    public XResultData importFiles() {
        File[] files = new File[]{this.sourceFile};
        this.results.combine(this.extractArtifacts(files, this.collector, this.collector.getParentRoughArtifact()));
        return this.results;
    }

    private XResultData extractArtifacts(File[] files, RoughArtifactCollector collector, RoughArtifact parentArtifact) {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                this.results.combine(this.processFile(file, collector, parentArtifact));
            } else if (file.isDirectory()) {
                RoughArtifact directoryArtifact = new RoughArtifact(this.orcsApi, this.results, RoughArtifactKind.CONTAINER, file.getName());
                collector.addChildRoughArtifact(directoryArtifact);
                File[] subFiles = file.listFiles(this.extractor.getFileFilter());
                if (files.length > 0) {
                    this.results.combine(this.extractArtifacts(subFiles, collector, directoryArtifact));
                }
            } else {
                throw new OseeStateException("Source location [%s] is not a valid file or directory", new Object[]{file});
            }
            ++n2;
        }
        return this.results;
    }

    private XResultData processFile(File file, RoughArtifactCollector collector, RoughArtifact parent) {
        XResultData results = new XResultData();
        RoughArtifactCollector tempCollector = new RoughArtifactCollector(parent);
        try {
            results.combine(this.extractor.process(this.orcsApi, results, file.toURI(), tempCollector));
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        collector.addAllRoughArtifacts((Collection)tempCollector.getRoughArtifacts());
        collector.addAllRoughRelations((Collection)tempCollector.getRoughRelations());
        return results;
    }
}

