/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.osee.define.api.DefineTupleTypes;
import org.eclipse.osee.define.rest.FullHistoryTolerant;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class FastHistoryStrategy
extends FullHistoryTolerant {
    private final Map<ArtifactId, ArtifactId> codeunitToCommitMap = new HashMap<ArtifactId, ArtifactId>(10000);
    private final TransactionBuilder tx;
    private final HashSet<String> changeIds = new HashSet();
    private final boolean initialImport;

    public FastHistoryStrategy(ArtifactToken repository, OrcsApi orcsApi, TransactionBuilder tx, boolean initialImport, Map<String, ArtifactId> pathToCodeunitMap) {
        super(repository, orcsApi, pathToCodeunitMap);
        this.tx = tx;
        this.initialImport = initialImport;
    }

    @Override
    public void handleCodeUnit(BranchId branch, ArtifactId codeUnit, TransactionBuilder tx, ArtifactId repository, ArtifactId commit, DiffEntry.ChangeType changeType) {
        this.codeunitToCommitMap.put(codeUnit, commit);
    }

    @Override
    public TransactionBuilder getTransactionBuilder(OrcsApi orcsApi, BranchId branch, UserId account) {
        return this.tx;
    }

    @Override
    public TransactionToken finishImport() {
        this.pathToCodeunitMap.forEach((path, codeUnit) -> {
            GammaId gammaId = this.tx.addTuple4(DefineTupleTypes.GitLatest, (Object)this.repoArtifact, codeUnit, (Object)this.codeunitToCommitMap.get(codeUnit), (Object)ArtifactId.SENTINEL);
        });
        return this.tx.commit();
    }

    @Override
    public void finishGitCommit(TransactionBuilder tx) {
    }

    @Override
    public boolean hasChangeIdAlredyImported(String changeId) {
        boolean imported = this.changeIds.contains(changeId) || !this.initialImport && super.hasChangeIdAlredyImported(changeId);
        this.changeIds.add(changeId);
        return imported;
    }
}

