/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.script.dsl.typesystem;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.osee.orcs.script.dsl.IExpressionResolver;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsExpression;
import org.eclipse.osee.orcs.script.dsl.typesystem.ExpressionTypeResolver;
import org.eclipse.osee.orcs.script.dsl.typesystem.ExpressionValueResolver;
import org.eclipse.osee.orcs.script.dsl.typesystem.NumberConverter;
import org.eclipse.osee.orcs.script.dsl.typesystem.TimestampConverter;

public class OsExpressionResolver
implements IExpressionResolver {
    @Inject
    private TimestampConverter tsConverter;
    @Inject
    private NumberConverter numberConverter;

    private boolean isCycleProtected() {
        return false;
    }

    @Override
    public <T> List<T> resolve(Class<T> clazz, OsExpression expression) {
        ExpressionValueResolver<T> resolver = new ExpressionValueResolver<T>(this.tsConverter, this.numberConverter, clazz, this.isCycleProtected());
        List<T> resolved = resolver.resolve(expression);
        return resolved != null ? resolved : Collections.emptyList();
    }

    @Override
    public <T> T resolveSingle(Class<T> clazz, OsExpression expression) {
        List<T> resolved = this.resolve(clazz, expression);
        return resolved != null && !resolved.isEmpty() ? (T)resolved.iterator().next() : null;
    }

    @Override
    public <T> List<T> resolve(Class<T> clazz, List<OsExpression> expressions) {
        ArrayList<T> toReturn = new ArrayList<T>();
        for (OsExpression expression : expressions) {
            List<T> resolved = this.resolve(clazz, expression);
            toReturn.addAll(resolved);
        }
        return toReturn;
    }

    @Override
    public List<Class<?>> resolveType(OsExpression expression) {
        ExpressionTypeResolver resolver = new ExpressionTypeResolver(this.tsConverter, this.isCycleProtected());
        List resolved = resolver.resolve(expression);
        return resolved != null ? resolved : Collections.emptyList();
    }

    @Override
    public Class<?> resolveTypeSingle(OsExpression expression) {
        List<Class<?>> resolved = this.resolveType(expression);
        return resolved != null && !resolved.isEmpty() ? resolved.iterator().next() : Void.class;
    }

    @Override
    public List<Class<?>> resolveTypes(List<OsExpression> expressions) {
        ArrayList toReturn = new ArrayList();
        for (OsExpression expression : expressions) {
            List<Class<?>> resolved = this.resolveType(expression);
            toReturn.addAll(resolved);
        }
        return toReturn;
    }
}

