/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workdef.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.ats.api.workdef.IAtsWidgetDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWidgetOptionHandler;
import org.eclipse.osee.ats.api.workdef.WidgetOption;
import org.eclipse.osee.ats.api.workdef.WidgetOptionHandler;
import org.eclipse.osee.ats.api.workdef.model.LayoutItem;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class WidgetDefinition
extends LayoutItem
implements IAtsWidgetDefinition {
    private AttributeTypeToken attributeType;
    private String toolTip;
    private String description;
    private int height;
    private String xWidgetName;
    private String defaultValue;
    private final WidgetOptionHandler options = new WidgetOptionHandler(new WidgetOption[0]);
    private Double min;
    private Double max;
    private final Map<String, Object> parameters = new HashMap<String, Object>();

    public WidgetDefinition(String name) {
        super(name);
    }

    public WidgetDefinition(String name, String xWidgetName, WidgetOption ... widgetOptions) {
        this(name, AttributeTypeToken.SENTINEL, xWidgetName, widgetOptions);
    }

    public WidgetDefinition(String name, AttributeTypeToken attrType, String xWidgetName, WidgetOption ... widgetOptions) {
        this(name);
        Conditions.assertNotNull((Object)attrType, (String)"attribute type can not be null for WidgetDefinition [%s]", (Object[])new Object[]{name});
        if (attrType.isValid()) {
            this.setAttributeType(attrType);
        }
        this.xWidgetName = xWidgetName;
        WidgetOption[] widgetOptionArray = widgetOptions;
        int n = widgetOptions.length;
        int n2 = 0;
        while (n2 < n) {
            WidgetOption opt = widgetOptionArray[n2];
            this.options.add(opt);
            ++n2;
        }
    }

    public WidgetDefinition(AttributeTypeToken attrType, String xWidgetName, WidgetOption ... widgetOptions) {
        this(attrType.getUnqualifiedName(), attrType, xWidgetName, widgetOptions);
    }

    @Override
    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    @Override
    public boolean is(WidgetOption widgetOption) {
        return this.options.contains(widgetOption);
    }

    @Override
    public void set(WidgetOption widgetOption) {
        this.options.add(widgetOption);
    }

    @Override
    public String getXWidgetName() {
        return this.xWidgetName;
    }

    @Override
    public void setXWidgetName(String xWidgetName) {
        this.xWidgetName = xWidgetName;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public String toString() {
        return String.format("[%s][%s]", this.getName(), this.getAttributeType() == null ? "" : this.getAttributeType().toStringWithId());
    }

    @Override
    public IAtsWidgetOptionHandler getOptions() {
        return this.options;
    }

    @Override
    public void setConstraint(double min, double max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public Double getMin() {
        return this.min;
    }

    @Override
    public Double getMax() {
        return this.max;
    }

    public void setAttributeType(AttributeTypeToken attributeTypeTok) {
        this.attributeType = attributeTypeTok;
    }

    @Override
    public AttributeTypeToken getAttributeType() {
        return this.attributeType;
    }

    @Override
    public void addParameter(String key, Object obj) {
        this.parameters.put(key, obj);
    }

    @Override
    public Object getParameter(String key) {
        return this.parameters.get(key);
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }
}

