/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.rule.validation;

import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.result.XResultBrowserHyperCmd;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.AHTML;

public abstract class AbstractValidationRule {
    protected final AtsApi atsApi;

    public AbstractValidationRule(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public void validateAll(Collection<ArtifactToken> artifacts, XResultData results) {
    }

    public abstract void validate(ArtifactToken var1, XResultData var2);

    public abstract String getRuleDescription();

    public abstract String getRuleTitle();

    public void logError(ArtifactToken artifact, String message, XResultData results) {
        String errStr = this.getHyperlink(artifact, message);
        results.errorf(errStr, new Object[0]);
    }

    public String getHyperlink(ArtifactToken artifact, String message) {
        String artTypeName = artifact.getArtifactType().getName();
        String link = this.getHyperlink("open", artifact.getIdString(), artifact.getBranch());
        return String.format("%s %s %s %s", artTypeName, artifact.toStringWithId(), message, link);
    }

    public String getHyperlink(String name, ArtifactId artifact, BranchId branch) {
        return this.getHyperlink(name, artifact.getIdString(), branch);
    }

    public String getHyperlink(String name, String id, BranchId branch) {
        return AHTML.getHyperlink((String)XResultBrowserHyperCmd.getHyperCmdStr((XResultBrowserHyperCmd)XResultBrowserHyperCmd.openArtifactBranch, (String)(String.valueOf(id) + "(" + branch.getId() + ")")), (String)name);
    }
}

