/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api;

import java.util.Date;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workflow.HasAssignees;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsGoal;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.log.IAtsLog;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;

public interface IAtsWorkItem
extends IAtsObject,
HasAssignees {
    public static final IAtsWorkItem SENTINEL = IAtsWorkItem.createSentinel();

    public String getAtsId();

    public IAtsTeamWorkflow getParentTeamWorkflow();

    public IAtsStateManager getStateMgr();

    public IAtsLog getLog();

    public IAtsWorkDefinition getWorkDefinition();

    public IAtsStateDefinition getStateDefinition();

    public IAtsUser getCreatedBy();

    public Date getCreatedDate();

    public IAtsUser getCompletedBy();

    public IAtsUser getCancelledBy();

    public String getCompletedFromState();

    public String getCancelledFromState();

    public String getArtifactTypeName();

    public Date getCompletedDate();

    public Date getCancelledDate();

    public String getCancelledReason();

    public IAtsAction getParentAction();

    default public boolean isTeamWorkflow() {
        return this.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow});
    }

    public boolean isOfType(ArtifactTypeId ... var1);

    default public boolean isDecisionReview() {
        return this.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.DecisionReview});
    }

    default public boolean isPeerReview() {
        return this.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.PeerToPeerReview});
    }

    default public boolean isTask() {
        return this.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task});
    }

    default public boolean isReview() {
        return this.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractReview});
    }

    default public boolean isGoal() {
        return this instanceof IAtsGoal;
    }

    default public boolean isInWork() {
        return this.getStateDefinition().getStateType().isWorkingState();
    }

    default public boolean isCompleted() {
        return this.getStateDefinition().getStateType().isCompletedState();
    }

    default public boolean isCancelled() {
        return this.getStateDefinition().getStateType().isCancelledState();
    }

    default public boolean isCompletedOrCancelled() {
        return this.isCompleted() || this.isCancelled();
    }

    public void setStateMgr(IAtsStateManager var1);

    public void clearCaches();

    default public String toStringWithId() {
        return String.format("[%s]-[%s]-[%s]", this.getName(), this.getAtsId(), this.getId());
    }

    public static IAtsWorkItem createSentinel() {
        final class IAtsWorkItemSentinel
        extends NamedIdBase
        implements IAtsWorkItem {
            IAtsWorkItemSentinel() {
            }

            @Override
            public ArtifactTypeId getArtifactType() {
                return null;
            }

            @Override
            public List<IAtsUser> getAssignees() {
                return null;
            }

            @Override
            public List<IAtsUser> getImplementers() {
                return null;
            }

            @Override
            public String getAtsId() {
                return null;
            }

            @Override
            public IAtsTeamWorkflow getParentTeamWorkflow() {
                return null;
            }

            @Override
            public IAtsStateManager getStateMgr() {
                return null;
            }

            @Override
            public IAtsLog getLog() {
                return null;
            }

            @Override
            public IAtsWorkDefinition getWorkDefinition() {
                return null;
            }

            @Override
            public IAtsStateDefinition getStateDefinition() {
                return null;
            }

            @Override
            public IAtsUser getCreatedBy() {
                return null;
            }

            @Override
            public Date getCreatedDate() {
                return null;
            }

            @Override
            public IAtsUser getCompletedBy() {
                return null;
            }

            @Override
            public IAtsUser getCancelledBy() {
                return null;
            }

            @Override
            public String getCompletedFromState() {
                return null;
            }

            @Override
            public String getCancelledFromState() {
                return null;
            }

            @Override
            public String getArtifactTypeName() {
                return null;
            }

            @Override
            public Date getCompletedDate() {
                return null;
            }

            @Override
            public Date getCancelledDate() {
                return null;
            }

            @Override
            public String getCancelledReason() {
                return null;
            }

            @Override
            public IAtsAction getParentAction() {
                return null;
            }

            @Override
            public boolean isOfType(ArtifactTypeId ... artifactType) {
                return false;
            }

            @Override
            public void setStateMgr(IAtsStateManager stateMgr) {
            }

            @Override
            public void clearCaches() {
            }
        }
        return new IAtsWorkItemSentinel();
    }
}

